/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.art.uilibrary.utils.UiScreenUtils;

public class PullDownAnimImage
extends ImageView {
    private View parent;
    private float mFirstPosition = 0.0f;
    private Boolean mScaling = false;
    private int minHeight;
    private int refreshHeight;
    private PullListener pullListener;

    public PullDownAnimImage(Context context) {
        super(context);
    }

    public PullDownAnimImage(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PullDownAnimImage(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setPullDownAinm(View parent) {
        this.setPullDownAinm(parent, 0, 0);
    }

    public void setPullDownAinm(View parent, int minHeight, int refreshHeight) {
        this.parent = parent;
        this.minHeight = minHeight;
        if (this.minHeight == 0) {
            this.minHeight = UiScreenUtils.getScreenW(this.getContext()) * 2 / 3;
        }
        this.refreshHeight = refreshHeight;
        if (this.refreshHeight == 0 || this.refreshHeight < this.minHeight) {
            this.refreshHeight = this.minHeight + UiScreenUtils.dp2Px(this.getContext(), 100.0f);
        }
        ViewGroup.LayoutParams pra = this.getLayoutParams();
        pra.width = UiScreenUtils.getScreenW(this.getContext());
        pra.height = this.minHeight;
        this.setLayoutParams(pra);
        if (parent instanceof RecyclerView) {
            final RecyclerView mRv = (RecyclerView)parent;
            mRv.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    ViewGroup.LayoutParams lp = PullDownAnimImage.this.getLayoutParams();
                    switch (event.getAction()) {
                        case 1: {
                            PullDownAnimImage.this.mScaling = false;
                            PullDownAnimImage.this.replyImage(PullDownAnimImage.this);
                            if (lp.height > PullDownAnimImage.this.refreshHeight) {
                                if (PullDownAnimImage.this.pullListener == null) break;
                                PullDownAnimImage.this.pullListener.refresh();
                                break;
                            }
                            if (PullDownAnimImage.this.pullListener == null) break;
                            PullDownAnimImage.this.pullListener.cancel();
                            break;
                        }
                        case 2: {
                            int distance;
                            if (!PullDownAnimImage.this.mScaling.booleanValue()) {
                                if (mRv.getLayoutManager() instanceof StaggeredGridLayoutManager) {
                                    int[] aa = ((StaggeredGridLayoutManager)mRv.getLayoutManager()).findFirstVisibleItemPositions(null);
                                    if (mRv.getChildAt(0).getY() != 0.0f || aa[0] != 1) break;
                                    PullDownAnimImage.this.mFirstPosition = event.getY();
                                } else if (mRv.getLayoutManager() instanceof LinearLayoutManager) {
                                    if (((LinearLayoutManager)mRv.getLayoutManager()).findViewByPosition(((LinearLayoutManager)mRv.getLayoutManager()).findFirstVisibleItemPosition()).getTop() != 0 || ((LinearLayoutManager)mRv.getLayoutManager()).findFirstVisibleItemPosition() != 0) break;
                                    PullDownAnimImage.this.mFirstPosition = event.getY();
                                }
                            }
                            if ((distance = (int)((double)(event.getY() - PullDownAnimImage.this.mFirstPosition) * 0.6)) < 0) break;
                            PullDownAnimImage.this.mScaling = true;
                            lp.width = UiScreenUtils.getScreenW(PullDownAnimImage.this.getContext()) + distance;
                            int deltaY = distance * 2 / 3;
                            if (PullDownAnimImage.this.pullListener != null && deltaY > 0) {
                                PullDownAnimImage.this.pullListener.change(deltaY);
                            }
                            lp.height = PullDownAnimImage.this.minHeight + deltaY;
                            PullDownAnimImage.this.setLayoutParams(lp);
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
    }

    private void replyImage(final ImageView imageView) {
        final ViewGroup.LayoutParams lp = imageView.getLayoutParams();
        final float w = imageView.getLayoutParams().width;
        final float h = imageView.getLayoutParams().height;
        final float newW = UiScreenUtils.getScreenW(this.getContext());
        final float newH = this.minHeight;
        ValueAnimator anim2 = ObjectAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(200L);
        anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float cVal = ((Float)animation.getAnimatedValue()).floatValue();
                lp.width = (int)(w - (w - newW) * cVal);
                lp.height = (int)(h - (h - newH) * cVal);
                imageView.setLayoutParams(lp);
            }
        });
        anim2.start();
    }

    public void setPullListener(PullListener pullListener) {
        this.pullListener = pullListener;
    }

    public static interface PullListener {
        public void refresh();

        public void cancel();

        public void change(int var1);
    }
}

