/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.pullrefresh;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.art.uilibrary.pullrefresh.FooterLoadingLayout;
import com.art.uilibrary.pullrefresh.HeaderLoadingLayout;
import com.art.uilibrary.pullrefresh.ILoadingLayout;
import com.art.uilibrary.pullrefresh.LoadingLayout;
import com.art.uilibrary.pullrefresh.PullToRefreshBase;

public class PullToRefreshListView
extends PullToRefreshBase<ListView>
implements AbsListView.OnScrollListener {
    private ListView mListView;
    private LoadingLayout mLoadMoreFooterLayout;
    private AbsListView.OnScrollListener mScrollListener;

    public PullToRefreshListView(Context context) {
        this(context, null);
        this.setOverScrollMode(2);
    }

    public PullToRefreshListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.setOverScrollMode(2);
    }

    public PullToRefreshListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setOverScrollMode(2);
    }

    @Override
    protected ListView createRefreshableView(Context context, AttributeSet attrs) {
        ListView listView;
        this.mListView = listView = new ListView(context);
        listView.setOnScrollListener((AbsListView.OnScrollListener)this);
        return listView;
    }

    public void setHasMoreData(boolean hasMoreData) {
        if (!hasMoreData) {
            LoadingLayout footerLoadingLayout;
            if (this.mLoadMoreFooterLayout != null) {
                this.mLoadMoreFooterLayout.setState(ILoadingLayout.State.NO_MORE_DATA);
            }
            if ((footerLoadingLayout = this.getFooterLoadingLayout()) != null) {
                footerLoadingLayout.setState(ILoadingLayout.State.NO_MORE_DATA);
            }
        }
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mScrollListener = l;
    }

    @Override
    protected boolean isReadyForPullUp() {
        return this.isLastItemVisible();
    }

    @Override
    protected boolean isReadyForPullDown() {
        return this.isFirstItemVisible();
    }

    @Override
    protected void startLoading() {
        super.startLoading();
        if (this.mLoadMoreFooterLayout != null) {
            this.mLoadMoreFooterLayout.setState(ILoadingLayout.State.REFRESHING);
        }
    }

    @Override
    public void onPullUpRefreshComplete() {
        super.onPullUpRefreshComplete();
        if (this.mLoadMoreFooterLayout != null) {
            this.mLoadMoreFooterLayout.setState(ILoadingLayout.State.RESET);
        }
    }

    @Override
    public void setScrollLoadEnabled(boolean scrollLoadEnabled) {
        if (this.isScrollLoadEnabled() == scrollLoadEnabled) {
            return;
        }
        super.setScrollLoadEnabled(scrollLoadEnabled);
        if (scrollLoadEnabled) {
            if (this.mLoadMoreFooterLayout == null) {
                this.mLoadMoreFooterLayout = new FooterLoadingLayout(this.getContext());
                this.mListView.addFooterView((View)this.mLoadMoreFooterLayout, null, false);
            }
            this.mLoadMoreFooterLayout.show(true);
        } else if (this.mLoadMoreFooterLayout != null) {
            this.mLoadMoreFooterLayout.show(false);
        }
    }

    @Override
    public LoadingLayout getFooterLoadingLayout() {
        if (this.isScrollLoadEnabled()) {
            return this.mLoadMoreFooterLayout;
        }
        return super.getFooterLoadingLayout();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.isScrollLoadEnabled() && this.hasMoreData() && (scrollState == 0 || scrollState == 2) && this.isReadyForPullUp()) {
            this.startLoading();
        }
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    @Override
    protected LoadingLayout createHeaderLoadingLayout(Context context, AttributeSet attrs) {
        return new HeaderLoadingLayout(context);
    }

    private boolean hasMoreData() {
        return this.mLoadMoreFooterLayout == null || this.mLoadMoreFooterLayout.getState() != ILoadingLayout.State.NO_MORE_DATA;
    }

    private boolean isFirstItemVisible() {
        ListAdapter adapter = this.mListView.getAdapter();
        if (adapter == null || adapter.isEmpty()) {
            return true;
        }
        int mostTop = this.mListView.getChildCount() > 0 ? this.mListView.getChildAt(0).getTop() : 0;
        return mostTop >= 0;
    }

    private boolean isLastItemVisible() {
        int childCount;
        int childIndex;
        int index;
        View lastVisibleChild;
        ListAdapter adapter = this.mListView.getAdapter();
        if (adapter == null || adapter.isEmpty()) {
            return true;
        }
        int lastItemPosition = adapter.getCount() - 1;
        int lastVisiblePosition = this.mListView.getLastVisiblePosition();
        if (lastVisiblePosition >= lastItemPosition - 1 && (lastVisibleChild = this.mListView.getChildAt(index = Math.min(childIndex = lastVisiblePosition - this.mListView.getFirstVisiblePosition(), (childCount = this.mListView.getChildCount()) - 1))) != null) {
            return lastVisibleChild.getBottom() <= this.mListView.getBottom();
        }
        return false;
    }
}

