/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.clipphotoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;

public class ClipPhotoRectView
extends View {
    private static final int STROKE_WIDTH = 5;
    private Context context;
    private int mRadius;

    public ClipPhotoRectView(Context context) {
        super(context);
        this.context = context;
    }

    public ClipPhotoRectView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public ClipPhotoRectView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawMask(canvas);
    }

    private void drawMask(Canvas canvas) {
        DisplayMetrics metrics = this.context.getResources().getDisplayMetrics();
        int screenWidth = metrics.widthPixels;
        int screenHeight = metrics.heightPixels;
        this.mRadius = (screenWidth - 200) / 2;
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c1 = new Canvas(bitmap);
        c1.drawARGB(150, 0, 0, 0);
        Paint strokePaint = new Paint();
        strokePaint.setAntiAlias(true);
        strokePaint.setColor(-1);
        strokePaint.setStyle(Paint.Style.STROKE);
        strokePaint.setStrokeWidth(5.0f);
        c1.drawRect(100.0f, (float)(screenHeight / 2 - this.mRadius), (float)(screenWidth - 100), (float)(screenHeight / 2 + this.mRadius), strokePaint);
        Bitmap circleBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c2 = new Canvas(circleBitmap);
        Paint circlePaint = new Paint();
        circlePaint.setStyle(Paint.Style.FILL);
        circlePaint.setColor(-65536);
        circlePaint.setAntiAlias(true);
        c2.drawRect(100.0f, (float)(screenHeight / 2 - this.mRadius), (float)(screenWidth - 100), (float)(screenHeight / 2 + this.mRadius), circlePaint);
        Paint paint = new Paint();
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        c1.drawBitmap(circleBitmap, 0.0f, 0.0f, paint);
        paint.setXfermode(null);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
    }
}

