/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.wheel.adapter;

import android.content.Context;
import android.graphics.Color;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.art.uilibrary.wheel.OnWheelChangedListener;
import com.art.uilibrary.wheel.WheelView;
import com.art.uilibrary.wheel.adapter.AbstractWheelAdapter;

public abstract class AbstractWheelTextAdapter
extends AbstractWheelAdapter {
    private static final int TEXT_VIEW_ITEM_RESOURCE = -1;
    private static final int DEFAULT_TEXT_COLOR = -13421773;
    public static final int LABEL_COLOR = -9437072;
    private static final int DEFAULT_TEXT_SIZE = 18;
    private static final int NO_RESOURCE = 0;
    private final Context context;
    private final LayoutInflater inflater;
    private int itemResourceId;
    private int itemTextResourceId;
    private int emptyItemResourceId;
    WheelView wheelView;
    private int textColor = -13421773;
    private int textSize = 18;

    AbstractWheelTextAdapter(Context context) {
        this(context, -1);
    }

    private AbstractWheelTextAdapter(Context context, int itemResource) {
        this(context, itemResource, 0);
    }

    public AbstractWheelTextAdapter(Context context, int itemResource, int itemTextResource) {
        this.context = context;
        this.itemResourceId = itemResource;
        this.itemTextResourceId = itemTextResource;
        this.inflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public int getItemResource() {
        return this.itemResourceId;
    }

    public void setItemResource(int itemResourceId) {
        this.itemResourceId = itemResourceId;
    }

    public int getItemTextResource() {
        return this.itemTextResourceId;
    }

    public void setItemTextResource(int itemTextResourceId) {
        this.itemTextResourceId = itemTextResourceId;
    }

    public int getEmptyItemResource() {
        return this.emptyItemResourceId;
    }

    public void setEmptyItemResource(int emptyItemResourceId) {
        this.emptyItemResourceId = emptyItemResourceId;
    }

    protected abstract CharSequence getItemText(int var1);

    @Override
    public View getItem(final int index, View convertView, ViewGroup parent) {
        if (index >= 0 && index < this.getItemsCount()) {
            TextView textView;
            if (convertView == null) {
                convertView = this.getView(this.itemResourceId, parent);
            }
            if ((textView = this.getTextView(convertView, this.itemTextResourceId)) != null) {
                CharSequence text = this.getItemText(index);
                if (text == null) {
                    text = "";
                }
                textView.setText(text);
                final int orangeColor = Color.parseColor((String)"#ffffff");
                if (this.wheelView != null) {
                    this.wheelView.addChangingListener(new OnWheelChangedListener(){

                        @Override
                        public void onChanged(WheelView wheel, int oldValue, int newValue) {
                            if (AbstractWheelTextAdapter.this.itemResourceId == -1) {
                                if (AbstractWheelTextAdapter.this.wheelView != null && index == newValue) {
                                    AbstractWheelTextAdapter.this.configureTextView(textView, orangeColor, AbstractWheelTextAdapter.this.textSize + 2);
                                } else {
                                    AbstractWheelTextAdapter.this.configureTextView(textView, AbstractWheelTextAdapter.this.textColor, AbstractWheelTextAdapter.this.textSize);
                                }
                            }
                        }
                    });
                }
                if (this.itemResourceId == -1) {
                    if (this.wheelView != null && index == this.wheelView.getCurrentItem()) {
                        this.configureTextView(textView, orangeColor, this.textSize);
                    } else {
                        this.configureTextView(textView, this.textColor, this.textSize);
                    }
                }
            }
            return convertView;
        }
        return null;
    }

    @Override
    public View getEmptyItem(View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.getView(this.emptyItemResourceId, parent);
        }
        if (this.emptyItemResourceId == -1 && convertView instanceof TextView) {
            this.configureTextView((TextView)convertView, this.textColor, this.textSize);
        }
        return convertView;
    }

    private void configureTextView(TextView view, int color2, int size) {
        view.setTextColor(color2);
        view.setGravity(17);
        view.setTextSize((float)size);
        view.setLines(1);
        view.setLineSpacing(1.1f, 1.1f);
    }

    private TextView getTextView(View view, int textResource) {
        TextView text = null;
        try {
            if (textResource == 0 && view instanceof TextView) {
                text = (TextView)view;
            } else if (textResource != 0) {
                text = (TextView)view.findViewById(textResource);
            }
        }
        catch (ClassCastException e) {
            Log.e((String)"AbstractWheelAdapter", (String)"You must supply a resource ID for a TextView");
            throw new IllegalStateException("AbstractWheelAdapter requires the resource ID to be a TextView", e);
        }
        return text;
    }

    private View getView(int resource, ViewGroup parent) {
        switch (resource) {
            case 0: {
                return null;
            }
            case -1: {
                return new TextView(this.context);
            }
        }
        return this.inflater.inflate(resource, parent, false);
    }
}

