/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.viewpager;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;

public class SmoothViewPager
extends ViewPager {
    private float mLastMotionY = -1.0f;
    private float mLastMotionX = -1.0f;
    private boolean mIsHandledTouchEvent = false;

    public SmoothViewPager(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.mLastMotionY = event.getY();
                this.mLastMotionX = event.getX();
                this.mIsHandledTouchEvent = false;
                break;
            }
            case 2: {
                float deltaY = event.getY() - this.mLastMotionY;
                float absDiffY = Math.abs(deltaY);
                float deltaX = event.getX() - this.mLastMotionX;
                float absDiffX = Math.abs(deltaX);
                if (absDiffY > absDiffX) {
                    this.mLastMotionY = event.getY();
                    this.mLastMotionX = event.getX();
                    this.mIsHandledTouchEvent = true;
                    break;
                }
                this.mLastMotionX = event.getX();
                this.mLastMotionY = event.getY();
                this.mIsHandledTouchEvent = false;
            }
        }
        this.getParent().requestDisallowInterceptTouchEvent(!this.mIsHandledTouchEvent);
        return super.dispatchTouchEvent(event);
    }
}

