/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget.dialog;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.art.uilibrary.R;
import com.art.uilibrary.wheel.OnWheelChangedListener;
import com.art.uilibrary.wheel.WheelView;
import com.art.uilibrary.wheel.adapter.ArrayWheelAdapter;
import com.art.uilibrary.widget.dialog.OralDialog;

public class WheelDialog
extends OralDialog {
    private WheelView wheelView;
    private ArrayWheelAdapter<String> wheelAdapter;
    private TextView mWheelTitle;
    private String curentIndex;

    public WheelDialog(Context context, String[] items, OralDialog.IOnDialogItemListener listener) {
        super(context);
        this.items = items;
        this.listener = listener;
    }

    public WheelDialog(String curentIndex, Context context, String[] items, OralDialog.IOnDialogItemListener listener) {
        super(context);
        this.items = items;
        this.listener = listener;
        this.curentIndex = curentIndex;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_wheel);
        LinearLayout mLayout = (LinearLayout)this.findViewById(R.id.layout);
        this.wheelView = new WheelView(this.context);
        this.wheelAdapter = new ArrayWheelAdapter<String>(this.context, this.items, this.wheelView);
        this.wheelView.setViewAdapter(this.wheelAdapter);
        this.wheelView.addChangingListener(new OnWheelChangedListener(){

            @Override
            public void onChanged(WheelView wheel, int oldValue, int newValue) {
                WheelDialog.this.mWheelTitle.setText(WheelDialog.this.wheelAdapter.getItemText(newValue));
            }
        });
        mLayout.addView((View)this.wheelView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        this.findViewById(R.id.cancel).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.confirm).setOnClickListener((View.OnClickListener)this);
        this.mWheelTitle = (TextView)this.findViewById(R.id.pop_title);
        this.wheelView.setInterpolator((Interpolator)new DecelerateInterpolator());
        if (this.curentIndex != null) {
            this.mWheelTitle.setText((CharSequence)this.curentIndex);
            this.wheelView.setCurrentItem(this.getArrayIndex(this.curentIndex, this.items));
        }
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (v.getId() == R.id.confirm) {
            this.listener.onDialogItemSelected(this.wheelView.getCurrentItem());
        }
    }

    public void invalidateData(String[] items) {
        this.items = items;
        this.wheelAdapter = new ArrayWheelAdapter<String>(this.context, items);
        this.wheelView.setViewAdapter(this.wheelAdapter);
    }

    public void setItemSelected(int index) {
        this.wheelView.setCurrentItem(index);
    }

    public void setItemSelected(String item) {
        int index = 0;
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.items[i].equals(item)) continue;
            index = i;
            break;
        }
        this.wheelView.setCurrentItem(index);
    }

    public int getArrayIndex(String str, String[] items) {
        int k = 0;
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equals(str)) continue;
            k = i;
        }
        return k;
    }
}

