/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.art.uilibrary.R;

public class AlertDialog {
    private Context mContext;
    private Dialog mDialog;
    private View mLayout;
    private TextView mTitleTv;
    private TextView mMsgTv;
    private TextView mNegBtn;
    private TextView mPosBtn;
    private View mLine;

    public AlertDialog(Context context) {
        this.mContext = context;
    }

    public AlertDialog builder() {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.dialog_alert, null);
        this.mLayout = view.findViewById(R.id.lLayout_bg);
        this.mTitleTv = (TextView)view.findViewById(R.id.txt_title);
        this.mMsgTv = (TextView)view.findViewById(R.id.txt_msg);
        this.mNegBtn = (TextView)view.findViewById(R.id.btn_neg);
        this.mPosBtn = (TextView)view.findViewById(R.id.btn_pos);
        this.mLine = view.findViewById(R.id.line);
        this.mDialog = new Dialog(this.mContext, R.style.AlertDialogStyle);
        this.mDialog.setContentView(view);
        return this;
    }

    public AlertDialog setTitle(Object title) {
        if (title instanceof String) {
            if (!TextUtils.isEmpty((CharSequence)title.toString())) {
                this.mTitleTv.setText((CharSequence)title.toString());
                this.setTitleVisible(true);
            } else {
                this.setTitleVisible(false);
            }
        } else if (title instanceof Integer) {
            this.mTitleTv.setText(((Integer)title).intValue());
        }
        return this;
    }

    public AlertDialog setTitleImg(int titleImg) {
        Drawable drawable2 = this.mContext.getResources().getDrawable(titleImg);
        if (titleImg != 0) {
            drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
            this.mTitleTv.setCompoundDrawables(drawable2, null, null, null);
        }
        return this;
    }

    public AlertDialog setMsg(Object msg) {
        if (msg instanceof Integer) {
            this.mMsgTv.setText(((Integer)msg).intValue());
        } else if (msg instanceof String && !TextUtils.isEmpty((CharSequence)msg.toString())) {
            this.mMsgTv.setText((CharSequence)msg.toString());
        }
        return this;
    }

    public AlertDialog setMsgImg(int msgImg) {
        Drawable drawable2 = this.mContext.getResources().getDrawable(msgImg);
        if (msgImg != 0) {
            drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
            this.mMsgTv.setCompoundDrawables(drawable2, null, null, null);
        }
        return this;
    }

    public AlertDialog setCancelable(boolean cancel) {
        this.mDialog.setCancelable(cancel);
        return this;
    }

    public AlertDialog setPositiveButton(Object text, final View.OnClickListener listener) {
        if (text instanceof String) {
            if (!TextUtils.isEmpty((CharSequence)text.toString())) {
                this.mPosBtn.setText((CharSequence)text.toString());
            }
        } else if (text instanceof Integer) {
            this.mPosBtn.setText(((Integer)text).intValue());
        }
        this.mPosBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(v);
                }
                AlertDialog.this.dismiss();
            }
        });
        return this;
    }

    public AlertDialog setNegativeButton(Object msg, final View.OnClickListener listener) {
        if (msg instanceof Integer) {
            this.mNegBtn.setText(((Integer)msg).intValue());
        } else if (msg instanceof String && !TextUtils.isEmpty((CharSequence)msg.toString())) {
            this.mNegBtn.setText((CharSequence)msg.toString());
        }
        this.mNegBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                listener.onClick(v);
                AlertDialog.this.mDialog.dismiss();
            }
        });
        return this;
    }

    public void show() {
        this.mDialog.show();
    }

    public void dismiss() {
        if (null != this.mDialog && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        this.mDialog.setCanceledOnTouchOutside(cancel);
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener listener) {
        this.mDialog.setOnDismissListener(listener);
    }

    public boolean isShowing() {
        if (this.mDialog == null) {
            return false;
        }
        return this.mDialog.isShowing();
    }

    public void setTitleVisible(boolean visible) {
        this.mTitleTv.setVisibility(visible ? 0 : 8);
    }

    public void setNegInVisible() {
        this.mNegBtn.setVisibility(8);
        this.mLine.setVisibility(8);
    }

    public void setPosInVisible() {
        this.mPosBtn.setVisibility(8);
        this.mLine.setVisibility(8);
    }
}

