/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.art.uilibrary.R;

public class ToolBar
extends FrameLayout
implements View.OnClickListener {
    private final LayoutInflater mInflater;
    private final RelativeLayout mBarView;
    private final TextView mTitleTv;
    private final TextView mTitleRightTv;
    private final TextView mTitleRightIconFont;
    private final TextView mTitleLeftTv;
    private final ImageView mTitleRightIv;
    private final ImageView mTitleLeftIv;
    private View.OnClickListener mOnClickListener;

    public ToolBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mBarView = (RelativeLayout)this.mInflater.inflate(R.layout.tb_toolbar, null);
        this.addView((View)this.mBarView);
        this.mTitleTv = (TextView)this.mBarView.findViewById(R.id.toolbar_title);
        this.mTitleRightTv = (TextView)this.mBarView.findViewById(R.id.toolbar_tv_right);
        this.mTitleLeftTv = (TextView)this.mBarView.findViewById(R.id.toolbar_tv_left);
        this.mTitleRightIconFont = (TextView)this.mBarView.findViewById(R.id.toolbar_icon_font_right);
        this.mTitleRightIv = (ImageView)this.mBarView.findViewById(R.id.toolbar_iv_right);
        this.mTitleLeftIv = (ImageView)this.mBarView.findViewById(R.id.toolbar_iv_left);
        this.mBarView.findViewById(R.id.toolbar_home_left).setOnClickListener((View.OnClickListener)this);
        this.mBarView.findViewById(R.id.toolbar_home_right).setOnClickListener((View.OnClickListener)this);
    }

    public TextView getmTitleRightIconFont() {
        return this.mTitleRightIconFont;
    }

    public void setToolBarClickListener(View.OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    public void setTitle(Object titleRes) {
        this.setText(this.mTitleTv, titleRes);
    }

    private void setText(TextView titleTv, Object titleRes) {
        if (titleRes instanceof Integer) {
            if ((Integer)titleRes != 0) {
                titleTv.setText(((Integer)titleRes).intValue());
            }
        } else if (titleRes instanceof String) {
            titleTv.setText((CharSequence)((String)titleRes));
        }
    }

    private void setColor(TextView titleTv, int colorRes) {
        titleTv.setTextColor(colorRes);
    }

    public void setRightTitle(Object titleRes) {
        this.setText(this.mTitleRightTv, titleRes);
    }

    public void setRightColor(int colorRes) {
        this.setColor(this.mTitleRightTv, colorRes);
    }

    public void setRightEnabled(boolean enabled) {
        this.mTitleRightTv.setEnabled(enabled);
    }

    public TextView getRightTitle() {
        return this.mTitleRightTv;
    }

    public ImageView getLeftIv() {
        return this.mTitleLeftIv;
    }

    public void setLeftTitle(Object titleRes) {
        this.setText(this.mTitleLeftTv, titleRes);
    }

    public void setRightIv(int resId) {
        this.mTitleRightIv.setImageResource(resId);
    }

    public void onClick(View v) {
        if (this.mOnClickListener != null) {
            this.mOnClickListener.onClick(v);
        }
    }
}

