/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.TextView;
import com.art.uilibrary.R;

public class AutoTextView
extends TextView {
    private String[] mTextArr;
    private int[] mBgArr;

    public AutoTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AutoTextView);
        int textArrayRes = typedArray.getInteger(R.styleable.AutoTextView_text, R.array.follow_text);
        int bgArrayRes = typedArray.getInteger(R.styleable.AutoTextView_background, R.array.follow_background);
        this.mTextArr = context.getResources().getStringArray(textArrayRes);
        this.mBgArr = context.getResources().getIntArray(bgArrayRes);
        this.setText(this.mTextArr[0]);
        this.setBackgroundResource(this.mBgArr[2]);
        typedArray.recycle();
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.setText(selected ? this.mTextArr[2] : this.mTextArr[0]);
        this.setBackgroundResource(selected ? this.mBgArr[2] : this.mBgArr[0]);
    }
}

