/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.pullrefresh;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.art.uilibrary.pullrefresh.ILoadingLayout;

public abstract class LoadingLayout
extends FrameLayout
implements ILoadingLayout {
    private View mContainer;
    private ILoadingLayout.State mCurState = ILoadingLayout.State.NONE;
    private ILoadingLayout.State mPreState = ILoadingLayout.State.NONE;

    public LoadingLayout(Context context) {
        this(context, null);
    }

    public LoadingLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoadingLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContainer = this.createLoadingView(context, attrs);
        if (this.mContainer == null) {
            throw new NullPointerException("Loading view can not be null.");
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        this.addView(this.mContainer, (ViewGroup.LayoutParams)params);
    }

    public void show(boolean show) {
        if (show == (this.getVisibility() == 0)) {
            return;
        }
        ViewGroup.LayoutParams params = this.mContainer.getLayoutParams();
        if (params != null) {
            params.height = show ? -2 : 0;
            this.requestLayout();
            this.setVisibility(show ? 0 : 4);
        }
    }

    public void setLastUpdatedLabel(CharSequence label) {
    }

    public void setLoadingDrawable(Drawable drawable2) {
    }

    public void setPullLabel(CharSequence pullLabel) {
    }

    public void setRefreshingLabel(CharSequence refreshingLabel) {
    }

    public void setReleaseLabel(CharSequence releaseLabel) {
    }

    @Override
    public ILoadingLayout.State getState() {
        return this.mCurState;
    }

    @Override
    public void setState(ILoadingLayout.State state) {
        if (this.mCurState != state) {
            this.mPreState = this.mCurState;
            this.mCurState = state;
            this.onStateChanged(state, this.mPreState);
        }
    }

    @Override
    public void onPull(float scale) {
    }

    protected ILoadingLayout.State getPreState() {
        return this.mPreState;
    }

    protected void onStateChanged(ILoadingLayout.State curState, ILoadingLayout.State oldState) {
        switch (curState) {
            case RESET: {
                this.onReset();
                break;
            }
            case RELEASE_TO_REFRESH: {
                this.onReleaseToRefresh();
                break;
            }
            case PULL_TO_REFRESH: {
                this.onPullToRefresh();
                break;
            }
            case REFRESHING: {
                this.onRefreshing();
                break;
            }
            case NO_MORE_DATA: {
                this.onNoMoreData();
                break;
            }
            case RELEASE_TO_DEEP: {
                this.onReleaseToDeep();
                break;
            }
        }
    }

    protected void onReset() {
    }

    protected void onPullToRefresh() {
    }

    protected void onReleaseToRefresh() {
    }

    protected void onReleaseToDeep() {
    }

    public void onRefreshing() {
    }

    void onNoMoreData() {
    }

    @Override
    public abstract int getContentSize();

    protected abstract View createLoadingView(Context var1, AttributeSet var2);
}

