/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.nui.multiphotopicker.util;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import com.art.uilibrary.nui.multiphotopicker.model.ImageBucket;
import com.art.uilibrary.nui.multiphotopicker.model.ImageItem;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ImageFetcher {
    private static ImageFetcher instance;
    private boolean hasBuildImagesBucketList = false;
    private Context mContext;
    private final LinkedHashMap<String, ImageBucket> mBucketList = new LinkedHashMap();
    private final HashMap<String, String> mThumbnailList = new HashMap();

    private ImageFetcher() {
    }

    private ImageFetcher(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageFetcher getInstance(Context context) {
        if (instance != null) return instance;
        Class<ImageFetcher> clazz = ImageFetcher.class;
        synchronized (ImageFetcher.class) {
            instance = new ImageFetcher(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public List<ImageBucket> getImagesBucketList(boolean refresh) {
        this.mBucketList.clear();
        this.mThumbnailList.clear();
        if (refresh || !refresh && !this.hasBuildImagesBucketList) {
            this.buildImagesBucketList();
        }
        ArrayList<ImageBucket> tmpList = new ArrayList<ImageBucket>();
        for (Map.Entry<String, ImageBucket> entry : this.mBucketList.entrySet()) {
            tmpList.add(entry.getValue());
        }
        return tmpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildImagesBucketList() {
        try (Cursor cur = null;){
            long startTime = System.currentTimeMillis();
            this.getThumbnail();
            String sortOrder = "datetaken DESC ";
            String[] columns = new String[]{"_id", "bucket_id", "_data", "bucket_display_name"};
            cur = this.mContext.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, columns, null, null, sortOrder);
            if (cur.moveToFirst()) {
                int photoIDIndex = cur.getColumnIndexOrThrow("_id");
                int photoPathIndex = cur.getColumnIndexOrThrow("_data");
                int bucketDisplayNameIndex = cur.getColumnIndexOrThrow("bucket_display_name");
                int bucketIdIndex = cur.getColumnIndexOrThrow("bucket_id");
                do {
                    String _id = cur.getString(photoIDIndex);
                    String path = cur.getString(photoPathIndex);
                    File file = new File(path);
                    if (file.exists() && file.length() > 0L && ImageFetcher.isSupportType(path)) {
                        String bucketName = cur.getString(bucketDisplayNameIndex);
                        String bucketId = cur.getString(bucketIdIndex);
                        ImageBucket bucket = this.mBucketList.get(bucketId);
                        if (bucket == null) {
                            bucket = new ImageBucket();
                            this.mBucketList.put(bucketId, bucket);
                            bucket.imageList = new ArrayList<ImageItem>();
                            bucket.bucketName = bucketName;
                        }
                        ++bucket.count;
                        ImageItem imageItem = new ImageItem();
                        imageItem.imageId = _id;
                        imageItem.sourcePath = path;
                        imageItem.thumbnailPath = this.mThumbnailList.get(_id);
                        imageItem.index = bucket.imageList.size();
                        bucket.imageList.add(imageItem);
                        continue;
                    }
                    Log.e((String)"ImageFetcher", (String)path);
                } while (cur.moveToNext());
            }
            this.hasBuildImagesBucketList = true;
            long endTime = System.currentTimeMillis();
            Log.d((String)ImageFetcher.class.getName(), (String)("use time: " + (endTime - startTime) + " ms"));
        }
    }

    private void getThumbnail() {
        try (Cursor cursor = null;){
            String[] projection = new String[]{"image_id", "_data"};
            cursor = this.mContext.getContentResolver().query(MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, projection, null, null, null);
            this.getThumbnailColumnData(cursor);
        }
    }

    private void getThumbnailColumnData(Cursor cur) {
        if (cur.moveToFirst()) {
            int image_idColumn = cur.getColumnIndex("image_id");
            int dataColumn = cur.getColumnIndex("_data");
            do {
                int image_id = cur.getInt(image_idColumn);
                String path = cur.getString(dataColumn);
                File file = new File(path);
                if (file.exists() && file.length() > 0L && ImageFetcher.isSupportType(path)) {
                    this.mThumbnailList.put("" + image_id, path);
                    continue;
                }
                Log.e((String)"ImageFetcher", (String)path);
            } while (cur.moveToNext());
        }
    }

    public List<ImageItem> getSystemPhotoList(Context context) {
        String sortOrder;
        String[] columns;
        ArrayList<ImageItem> result = new ArrayList<ImageItem>();
        Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(uri, columns = new String[]{"_id", "_data"}, null, null, sortOrder = "datetaken DESC ");
        if (cursor == null || cursor.getCount() <= 0) {
            return null;
        }
        int position = 0;
        while (cursor.moveToNext()) {
            int index = cursor.getColumnIndexOrThrow("_data");
            String path = cursor.getString(index);
            File file = new File(path);
            if (file.exists() && file.length() > 0L && ImageFetcher.isSupportType(path)) {
                ImageItem imageItem = new ImageItem();
                imageItem.sourcePath = path;
                int photoIDIndex = cursor.getColumnIndexOrThrow("_id");
                String _id = cursor.getString(photoIDIndex);
                imageItem.thumbnailPath = this.mThumbnailList.get(_id);
                imageItem.index = position++;
                result.add(imageItem);
                continue;
            }
            Log.e((String)"ImageFetcher", (String)path);
        }
        return result;
    }

    public static boolean isSupportType(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        String lowPath = path.toLowerCase();
        return lowPath.endsWith("png") || lowPath.endsWith("jpg") || lowPath.endsWith("jpeg") || lowPath.endsWith("gif");
    }
}

