/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.nui.multiphotopicker.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import com.art.uilibrary.R;
import com.art.uilibrary.base.OralAdapter;
import com.art.uilibrary.nui.multiphotopicker.model.ImageItem;
import com.art.uilibrary.nui.multiphotopicker.util.ImageDisplayer;

public class ImagePublishAdapter
extends OralAdapter<ImageItem> {
    private IOnItemSelectedListener listener;

    public ImagePublishAdapter(Context context) {
        super(context);
    }

    @Override
    public int getCount() {
        if (this.list == null) {
            return 1;
        }
        if (this.list.size() == 3) {
            return 3;
        }
        return this.list.size() + 1;
    }

    @Override
    public Object getItem(int position) {
        if (this.list != null && this.list.size() == 3) {
            return this.list.get(position);
        }
        if (this.list == null || position - 1 < 0 || position > this.list.size()) {
            return null;
        }
        return this.list.get(position - 1);
    }

    @SuppressLint(value={"ViewHolder"})
    public View getView(final int position, View convertView, ViewGroup parent) {
        convertView = this.getInflateView(R.layout.up_item_publish);
        ImageView imageIv = (ImageView)convertView.findViewById(R.id.item_grid_image);
        ImageButton postreq_ib = (ImageButton)convertView.findViewById(R.id.postreq_ib);
        if (this.isShowAddItem(position)) {
            imageIv.setImageResource(R.mipmap.icon_oval_selected);
        } else {
            ImageItem item = (ImageItem)this.list.get(position);
            if (item.isUpload == 0) {
                postreq_ib.setVisibility(8);
            } else {
                postreq_ib.setVisibility(0);
                if (item.isUpload == 1) {
                    // empty if block
                }
            }
            ImageDisplayer.getInstance(this.mContext).displayBmp(imageIv, item.thumbnailPath, item.sourcePath);
        }
        imageIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImagePublishAdapter.this.listener.onItemSelected(position);
            }
        });
        return convertView;
    }

    private boolean isShowAddItem(int position) {
        int size = this.list == null ? 0 : this.list.size();
        return position == size;
    }

    public void setItemSelectedListener(IOnItemSelectedListener listener) {
        this.listener = listener;
    }

    public static interface IOnItemSelectedListener {
        public void onItemSelected(int var1);
    }
}

