/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.nui.multiphotopicker.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.art.uilibrary.R;
import com.art.uilibrary.base.OralAdapter;
import com.art.uilibrary.nui.multiphotopicker.model.ImageItem;
import com.art.uilibrary.nui.multiphotopicker.util.ImageDisplayer;

public class ImageGridAdapter
extends OralAdapter<ImageItem> {
    public ImageGridAdapter(Context context) {
        super(context);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder mHolder;
        if (convertView == null) {
            convertView = View.inflate((Context)this.mContext, (int)R.layout.up_item_image, null);
            mHolder = new ViewHolder();
            mHolder.imageIv = (ImageView)convertView.findViewById(R.id.image);
            mHolder.selectedIv = (ImageView)convertView.findViewById(R.id.selected_tag);
            mHolder.selectedBgTv = (TextView)convertView.findViewById(R.id.image_selected_bg);
            convertView.setTag((Object)mHolder);
        } else {
            mHolder = (ViewHolder)convertView.getTag();
        }
        ImageItem item = (ImageItem)this.list.get(position);
        ImageDisplayer.getInstance(this.mContext).displayBmp(mHolder.imageIv, item.thumbnailPath, item.sourcePath);
        if (item.isSelected) {
            mHolder.selectedIv.setImageDrawable(this.mContext.getResources().getDrawable(R.mipmap.icon_oval_selected));
            mHolder.selectedIv.setVisibility(0);
        } else {
            mHolder.selectedIv.setImageDrawable(null);
            mHolder.selectedIv.setVisibility(8);
        }
        return convertView;
    }

    static class ViewHolder {
        private ImageView imageIv;
        private ImageView selectedIv;
        private TextView selectedBgTv;

        ViewHolder() {
        }
    }
}

