/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.http.download;

import com.arialyy.aria.core.common.RequestEnum;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaHTTPException;
import com.arialyy.aria.http.BaseHttpThreadTaskAdapter;
import com.arialyy.aria.http.ConnectionHelp;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.BufferedRandomAccessFile;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Map;
import java.util.Set;

final class HttpDThreadTaskAdapter
extends BaseHttpThreadTaskAdapter {
    private final String TAG = "HttpDThreadTaskAdapter";
    private DTaskWrapper mTaskWrapper;

    HttpDThreadTaskAdapter(SubThreadConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlerThreadTask() {
        this.mTaskWrapper = (DTaskWrapper)this.getTaskWrapper();
        if (this.getThreadRecord().isComplete) {
            this.handleComplete();
            return;
        }
        URLConnection conn = null;
        BufferedInputStream is = null;
        BufferedRandomAccessFile file = null;
        try {
            Map<String, String> params;
            URL url = ConnectionHelp.handleUrl(this.getThreadConfig().url, this.mTaskOption);
            conn = ConnectionHelp.handleConnection(url, this.mTaskOption);
            if (this.mTaskWrapper.isSupportBP()) {
                ALog.d((String)"HttpDThreadTaskAdapter", (String)String.format("\u4efb\u52a1\u3010%s\u3011\u7ebf\u7a0b__%s__\u5f00\u59cb\u4e0b\u8f7d\u3010\u5f00\u59cb\u4f4d\u7f6e : %s\uff0c\u7ed3\u675f\u4f4d\u7f6e\uff1a%s\u3011", this.getFileName(), this.getThreadRecord().threadId, this.getThreadRecord().startLocation, this.getThreadRecord().endLocation));
                conn.setRequestProperty("Range", String.format("bytes=%s-%s", this.getThreadRecord().startLocation, this.getThreadRecord().endLocation - 1L));
            } else {
                ALog.w((String)"HttpDThreadTaskAdapter", (String)"\u8be5\u4e0b\u8f7d\u4e0d\u652f\u6301\u65ad\u70b9");
            }
            ConnectionHelp.setConnectParam(this.mTaskOption, (HttpURLConnection)conn);
            conn.setConnectTimeout(this.getTaskConfig().getConnectTimeOut());
            conn.setReadTimeout(this.getTaskConfig().getIOTimeOut());
            if (this.mTaskOption.isChunked()) {
                conn.setDoInput(true);
                ((HttpURLConnection)conn).setChunkedStreamingMode(0);
            }
            conn.connect();
            if (this.mTaskOption.getRequestEnum() == RequestEnum.POST && (params = this.mTaskOption.getParams()) != null) {
                OutputStreamWriter dos = new OutputStreamWriter(conn.getOutputStream());
                Set<String> keys = params.keySet();
                StringBuilder sb = new StringBuilder();
                for (String key : keys) {
                    sb.append(key).append("=").append(URLEncoder.encode(params.get(key))).append("&");
                }
                String paramStr = sb.toString();
                paramStr = paramStr.substring(0, paramStr.length() - 1);
                dos.write(paramStr);
                dos.flush();
                dos.close();
            }
            is = new BufferedInputStream(ConnectionHelp.convertInputStream((HttpURLConnection)conn));
            if (this.mTaskOption.isChunked()) {
                this.readChunked(is);
            } else if (this.getThreadConfig().isBlock) {
                this.readDynamicFile(is);
            } else {
                file = new BufferedRandomAccessFile(this.getThreadConfig().tempFile, "rwd", this.getTaskConfig().getBuffSize());
                if (this.getThreadRecord().startLocation > 0L) {
                    file.seek(this.getThreadRecord().startLocation);
                }
                this.readNormal(is, file);
                this.handleComplete();
            }
        }
        catch (MalformedURLException e) {
            this.fail((AriaException)new AriaHTTPException(String.format("\u4efb\u52a1\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25\uff0cfilePath: %s, url: %s", this.getFileName(), this.getEntity().getFilePath(), this.getEntity().getUrl()), (Exception)e), false);
        }
        catch (IOException e) {
            this.fail((AriaException)new AriaHTTPException(String.format("\u4efb\u52a1\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25\uff0cfilePath: %s, url: %s", this.getFileName(), this.getEntity().getFilePath(), this.getEntity().getUrl()), (Exception)e), true);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.fail((AriaException)new AriaHTTPException(String.format("\u4efb\u52a1\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25\uff0cfilePath: %s, url: %s", this.getFileName(), this.getEntity().getFilePath(), this.getEntity().getUrl()), (Exception)e), false);
        }
        catch (Exception e) {
            this.fail((AriaException)new AriaHTTPException(String.format("\u4efb\u52a1\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25\uff0cfilePath: %s, url: %s", this.getFileName(), this.getEntity().getFilePath(), this.getEntity().getUrl()), e), false);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
                if (is != null) {
                    is.close();
                }
                if (conn != null) {
                    conn.getInputStream().close();
                    ((HttpURLConnection)conn).disconnect();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readChunked(InputStream is) {
        FileOutputStream fos = null;
        try {
            int len;
            fos = new FileOutputStream(this.getThreadConfig().tempFile, true);
            byte[] buffer = new byte[this.getTaskConfig().getBuffSize()];
            while (this.getThreadTask().isLive() && (len = is.read(buffer)) != -1 && !this.getThreadTask().isBreak()) {
                if (this.mSpeedBandUtil != null) {
                    this.mSpeedBandUtil.limitNextBytes(len);
                }
                fos.write(buffer, 0, len);
                this.progress(len);
            }
            this.handleComplete();
        }
        catch (IOException e) {
            this.fail((AriaException)new AriaHTTPException(String.format("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0csavePath: %s, url: %s", this.getEntity().getFilePath(), this.getThreadConfig().url), (Exception)e), true);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDynamicFile(InputStream is) {
        OutputStream fos = null;
        AbstractInterruptibleChannel foc = null;
        Channel fic = null;
        try {
            int len;
            fos = new FileOutputStream(this.getThreadConfig().tempFile, true);
            foc = ((FileOutputStream)fos).getChannel();
            fic = Channels.newChannel(is);
            ByteBuffer bf = ByteBuffer.allocate(this.getTaskConfig().getBuffSize());
            while (this.getThreadTask().isLive() && (len = fic.read(bf)) != -1 && !this.getThreadTask().isBreak()) {
                if (this.mSpeedBandUtil != null) {
                    this.mSpeedBandUtil.limitNextBytes(len);
                }
                if (this.getRangeProgress() + (long)len >= this.getThreadRecord().endLocation) {
                    len = (int)(this.getThreadRecord().endLocation - this.getRangeProgress());
                    bf.flip();
                    ((FileOutputStream)fos).write(bf.array(), 0, len);
                    bf.compact();
                    this.progress(len);
                    break;
                }
                bf.flip();
                ((FileChannel)foc).write(bf);
                bf.compact();
                this.progress(len);
            }
            this.handleComplete();
        }
        catch (IOException e) {
            this.fail((AriaException)new AriaHTTPException(String.format("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0csavePath: %s, url: %s", this.getEntity().getFilePath(), this.getThreadConfig().url), (Exception)e), true);
        }
        finally {
            try {
                if (fos != null) {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                if (foc != null) {
                    foc.close();
                }
                if (fic != null) {
                    fic.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readNormal(InputStream is, BufferedRandomAccessFile file) throws IOException {
        int len;
        byte[] buffer = new byte[this.getTaskConfig().getBuffSize()];
        while (this.getThreadTask().isLive() && (len = is.read(buffer)) != -1 && !this.getThreadTask().isBreak()) {
            if (this.mSpeedBandUtil != null) {
                this.mSpeedBandUtil.limitNextBytes(len);
            }
            file.write(buffer, 0, len);
            this.progress(len);
        }
    }

    private void handleComplete() {
        if (this.getThreadTask().isBreak()) {
            return;
        }
        if (!this.getThreadTask().checkBlock()) {
            return;
        }
        this.complete();
    }
}

