/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.http.download;

import android.net.TrafficStats;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.common.RequestEnum;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.core.processor.IHttpFileLenAdapter;
import com.arialyy.aria.core.wrapper.ITaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaHTTPException;
import com.arialyy.aria.http.ConnectionHelp;
import com.arialyy.aria.http.HttpTaskOption;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import com.arialyy.aria.util.RecordUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

final class HttpDFileInfoTask
implements IInfoTask,
Runnable {
    private static final String TAG = "HttpDFileInfoTask";
    private DownloadEntity mEntity;
    private DTaskWrapper mTaskWrapper;
    private int mConnectTimeOut;
    private IInfoTask.Callback callback;
    private HttpTaskOption taskOption;

    HttpDFileInfoTask(DTaskWrapper taskWrapper) {
        this.mTaskWrapper = taskWrapper;
        this.mEntity = (DownloadEntity)taskWrapper.getEntity();
        this.mConnectTimeOut = AriaConfig.getInstance().getDConfig().getConnectTimeOut();
        this.taskOption = (HttpTaskOption)taskWrapper.getTaskOption();
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        TrafficStats.setThreadStatsTag((int)UUID.randomUUID().toString().hashCode());
        URLConnection conn = null;
        try {
            URL url = ConnectionHelp.handleUrl(this.mEntity.getUrl(), this.taskOption);
            conn = ConnectionHelp.handleConnection(url, this.taskOption);
            ConnectionHelp.setConnectParam(this.taskOption, (HttpURLConnection)conn);
            conn.setRequestProperty("Range", "bytes=0-");
            if (AriaConfig.getInstance().getDConfig().isUseHeadRequest()) {
                ALog.d((String)TAG, (String)"head\u8bf7\u6c42");
                ((HttpURLConnection)conn).setRequestMethod("HEAD");
            }
            conn.setConnectTimeout(this.mConnectTimeOut);
            conn.connect();
            this.handleConnect((HttpURLConnection)conn);
        }
        catch (IOException e) {
            this.failDownload(new AriaHTTPException(String.format("\u4e0b\u8f7d\u5931\u8d25\uff0cfilePath: %s, url: %s", this.mEntity.getFilePath(), this.mEntity.getUrl()), (Exception)e), true);
        }
        finally {
            if (conn != null) {
                try {
                    InputStream is = conn.getInputStream();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    public void setCallback(IInfoTask.Callback callback) {
        this.callback = callback;
    }

    private void handleConnect(HttpURLConnection conn) throws IOException {
        IHttpFileLenAdapter lenAdapter;
        Map<String, String> params;
        if (this.taskOption.getRequestEnum() == RequestEnum.POST && (params = this.taskOption.getParams()) != null) {
            OutputStreamWriter dos = new OutputStreamWriter(conn.getOutputStream());
            Set<String> keys = params.keySet();
            StringBuilder sb = new StringBuilder();
            for (String key : keys) {
                sb.append(key).append("=").append(URLEncoder.encode(params.get(key))).append("&");
            }
            String url = sb.toString();
            url = url.substring(0, url.length() - 1);
            dos.write(url);
            dos.flush();
            dos.close();
        }
        if ((lenAdapter = this.taskOption.getFileLenAdapter()) == null) {
            lenAdapter = new FileLenAdapter();
        } else {
            ALog.d((String)TAG, (String)"\u4f7f\u7528\u81ea\u5b9a\u4e49adapter");
        }
        long len = lenAdapter.handleFileLen(conn.getHeaderFields());
        if (!FileUtil.checkMemorySpace((String)this.mEntity.getFilePath(), (long)len)) {
            this.failDownload(new AriaHTTPException(String.format("\u4e0b\u8f7d\u5931\u8d25\uff0c\u5185\u5b58\u7a7a\u95f4\u4e0d\u8db3\uff1bfilePath: %s, url: %s", this.mEntity.getFilePath(), this.mEntity.getUrl())), false);
            return;
        }
        int code = conn.getResponseCode();
        boolean end = false;
        if (TextUtils.isEmpty((CharSequence)this.mEntity.getMd5Code())) {
            String md5Code = conn.getHeaderField("Content-MD5");
            this.mEntity.setMd5Code(md5Code);
        }
        boolean isChunked = false;
        String str = conn.getHeaderField("Transfer-Encoding");
        if (!TextUtils.isEmpty((CharSequence)str) && str.equals("chunked")) {
            isChunked = true;
        }
        Map<String, List<String>> headers = conn.getHeaderFields();
        String disposition = conn.getHeaderField("Content-Disposition");
        if (this.taskOption.isUseServerFileName()) {
            if (!TextUtils.isEmpty((CharSequence)disposition)) {
                this.mEntity.setDisposition(CommonUtil.encryptBASE64((String)disposition));
                this.handleContentDisposition(disposition);
            } else if (this.taskOption.getFileNameAdapter() != null) {
                String newName = this.taskOption.getFileNameAdapter().handleFileName(headers, this.mEntity.getKey());
                this.mEntity.setServerFileName(newName);
                this.renameFile(newName);
            }
        }
        CookieManager msCookieManager = new CookieManager();
        List<String> cookiesHeader = headers.get("Set-Cookie");
        if (cookiesHeader != null) {
            for (String cookie : cookiesHeader) {
                msCookieManager.getCookieStore().add(null, HttpCookie.parse(cookie).get(0));
            }
            this.taskOption.setCookieManager(msCookieManager);
        }
        this.mTaskWrapper.setCode(code);
        if (code == 206) {
            if (!this.checkLen(len) && !isChunked) {
                if (len < 0L) {
                    this.failDownload(new AriaHTTPException(String.format("\u4efb\u52a1\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u957f\u5ea6\u5c0f\u4e8e0\uff0c url: %s", this.mEntity.getUrl())), false);
                }
                return;
            }
            this.mEntity.setFileSize(len);
            this.mTaskWrapper.setSupportBP(true);
            end = true;
        } else if (code == 200) {
            String contentType = conn.getHeaderField("Content-Type");
            if (TextUtils.isEmpty((CharSequence)contentType)) {
                return;
            }
            if (contentType.equals("text/html")) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(ConnectionHelp.convertInputStream(conn)));
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                reader.close();
                this.handleUrlReTurn(conn, CommonUtil.getWindowReplaceUrl((String)sb.toString()));
                return;
            }
            if (!this.checkLen(len) && !isChunked) {
                if (len < 0L) {
                    this.failDownload(new AriaHTTPException(String.format("\u4efb\u52a1\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u957f\u5ea6\u5c0f\u4e8e0\uff0c url: %s", this.mEntity.getUrl())), false);
                }
                ALog.d((String)TAG, (String)"len < 0");
                return;
            }
            this.mEntity.setFileSize(len);
            this.mTaskWrapper.setNewTask(true);
            this.mTaskWrapper.setSupportBP(false);
            end = true;
        } else if (code == 302 || code == 301 || code == 303 || code == 201 || code == 307) {
            this.handleUrlReTurn(conn, conn.getHeaderField("Location"));
        } else if (code == 416) {
            ALog.w((String)TAG, (String)"\u6587\u4ef6\u957f\u5ea6\u4e3a0\uff0c\u4e0d\u652f\u6301\u65ad\u70b9");
            this.mTaskWrapper.setSupportBP(false);
            this.mTaskWrapper.setNewTask(true);
            end = true;
        } else if (code >= 400) {
            this.failDownload(new AriaHTTPException(String.format("\u4efb\u52a1\u4e0b\u8f7d\u5931\u8d25\uff0cerrorCode\uff1a%s, url: %s", code, this.mEntity.getUrl())), false);
        } else {
            this.failDownload(new AriaHTTPException(String.format("\u4efb\u52a1\u4e0b\u8f7d\u5931\u8d25\uff0cerrorCode\uff1a%s, errorMsg: %s, url: %s", code, conn.getResponseMessage(), this.mEntity.getUrl())), !CheckUtil.httpIsBadRequest((int)code));
        }
        if (end) {
            this.taskOption.setChunked(isChunked);
            if (this.callback != null) {
                CompleteInfo info = new CompleteInfo(code, (ITaskWrapper)this.mTaskWrapper);
                this.callback.onSucceed(this.mEntity.getUrl(), info);
            }
            this.mEntity.update();
        }
    }

    private void handleContentDisposition(String disposition) throws UnsupportedEncodingException {
        if (disposition.contains(";")) {
            String[] infos = disposition.split(";");
            if (infos[0].equals("attachment")) {
                for (String info : infos) {
                    String[] temp;
                    if (!info.startsWith("filename") || !info.contains("=") || (temp = info.split("=")).length <= 1) continue;
                    String newName = URLDecoder.decode(temp[1], "utf-8").replaceAll("\"", "");
                    this.mEntity.setServerFileName(newName);
                    this.renameFile(newName);
                    break;
                }
            } else if (infos[0].equals("form-data") && infos.length > 2) {
                String[] temp = infos[2].split("=");
                if (temp.length > 1) {
                    String newName = URLDecoder.decode(temp[1], "utf-8").replaceAll("\"", "");
                    this.mEntity.setServerFileName(newName);
                    this.renameFile(newName);
                }
            } else {
                ALog.w((String)TAG, (String)"\u4e0d\u8bc6\u522b\u7684Content-Disposition\u53c2\u6570");
            }
        }
    }

    private void renameFile(String newName) {
        if (TextUtils.isEmpty((CharSequence)newName)) {
            ALog.w((String)TAG, (String)"\u91cd\u547d\u540d\u5931\u8d25\u3010\u670d\u52a1\u5668\u8fd4\u56de\u7684\u6587\u4ef6\u540d\u4e3a\u7a7a\u3011");
            return;
        }
        ALog.d((String)TAG, (String)String.format("\u6587\u4ef6\u91cd\u547d\u540d\u4e3a\uff1a%s", newName));
        File oldFile = new File(this.mEntity.getFilePath());
        String newPath = oldFile.getParent() + "/" + newName;
        if (!CheckUtil.checkDPathConflicts((boolean)false, (String)newPath, (int)this.mTaskWrapper.getRequestType())) {
            ALog.e((String)TAG, (String)"\u6587\u4ef6\u91cd\u547d\u540d\u5931\u8d25");
            return;
        }
        if (oldFile.exists()) {
            boolean b = oldFile.renameTo(new File(newPath));
            ALog.d((String)TAG, (String)String.format("\u6587\u4ef6\u91cd\u547d\u540d%s", b ? "\u6210\u529f" : "\u5931\u8d25"));
        }
        this.mEntity.setFileName(newName);
        this.mEntity.setFilePath(newPath);
        RecordUtil.modifyTaskRecord((String)oldFile.getPath(), (String)newPath, (int)this.mEntity.getTaskType());
    }

    private void handleUrlReTurn(HttpURLConnection conn, String newUrl) throws IOException {
        ALog.d((String)TAG, (String)("30x\u8df3\u8f6c\uff0c\u65b0url\u4e3a\u3010" + newUrl + "\u3011"));
        if (TextUtils.isEmpty((CharSequence)newUrl) || newUrl.equalsIgnoreCase("null")) {
            if (this.callback != null) {
                this.callback.onFail((AbsEntity)this.mEntity, (AriaException)new AriaHTTPException("\u83b7\u53d6\u91cd\u5b9a\u5411\u94fe\u63a5\u5931\u8d25"), false);
            }
            return;
        }
        if (newUrl.startsWith("/")) {
            Uri uri = Uri.parse((String)this.mEntity.getUrl());
            newUrl = uri.getHost() + newUrl;
        }
        if (!CheckUtil.checkUrl((String)newUrl)) {
            this.failDownload(new AriaHTTPException("\u4e0b\u8f7d\u5931\u8d25\uff0c\u91cd\u5b9a\u5411url\u9519\u8bef"), false);
            return;
        }
        this.taskOption.setRedirectUrl(newUrl);
        this.mEntity.setRedirect(true);
        this.mEntity.setRedirectUrl(newUrl);
        String cookies = conn.getHeaderField("Set-Cookie");
        conn.disconnect();
        URL url = ConnectionHelp.handleUrl(newUrl, this.taskOption);
        conn = ConnectionHelp.handleConnection(url, this.taskOption);
        ConnectionHelp.setConnectParam(this.taskOption, conn);
        conn.setRequestProperty("Cookie", cookies);
        conn.setRequestProperty("Range", "bytes=0-");
        if (AriaConfig.getInstance().getDConfig().isUseHeadRequest()) {
            conn.setRequestMethod("HEAD");
        }
        conn.setConnectTimeout(this.mConnectTimeOut);
        conn.connect();
        this.handleConnect(conn);
        conn.disconnect();
    }

    private boolean checkLen(long len) {
        if (len != this.mEntity.getFileSize()) {
            ALog.d((String)TAG, (String)"\u957f\u5ea6\u4e0d\u4e00\u81f4\uff0c\u4efb\u52a1\u4e3a\u65b0\u4efb\u52a1");
            this.mTaskWrapper.setNewTask(true);
        }
        return true;
    }

    private void failDownload(AriaHTTPException e, boolean needRetry) {
        if (this.callback != null) {
            this.callback.onFail((AbsEntity)this.mEntity, (AriaException)e, needRetry);
        }
    }

    public void accept(ILoaderVisitor visitor) {
        visitor.addComponent((IInfoTask)this);
    }

    private static class FileLenAdapter
    implements IHttpFileLenAdapter {
        private FileLenAdapter() {
        }

        public long handleFileLen(Map<String, List<String>> headers) {
            long len;
            if (headers == null || headers.isEmpty()) {
                ALog.e((String)HttpDFileInfoTask.TAG, (String)"header\u4e3a\u7a7a\uff0c\u83b7\u53d6\u6587\u4ef6\u957f\u5ea6\u5931\u8d25");
                return -1L;
            }
            List<String> sLength = headers.get("Content-Length");
            if (sLength == null || sLength.isEmpty()) {
                return -1L;
            }
            String temp = sLength.get(0);
            long l = len = TextUtils.isEmpty((CharSequence)temp) ? -1L : Long.parseLong(temp);
            if (len < 0L) {
                List<String> sRange = headers.get("Content-Range");
                if (sRange == null || sRange.isEmpty()) {
                    len = -1L;
                } else {
                    int start = temp.indexOf("/");
                    len = Long.parseLong(temp.substring(start + 1));
                }
            }
            return len;
        }
    }
}

