/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.http;

import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.RecordHandler;
import com.arialyy.aria.core.common.RecordHelper;
import com.arialyy.aria.core.config.Configuration;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.http.HttpTaskOption;
import com.arialyy.aria.util.RecordUtil;
import java.util.ArrayList;

public final class HttpRecordHandler
extends RecordHandler {
    public HttpRecordHandler(AbsTaskWrapper wrapper) {
        super(wrapper);
    }

    public void handlerTaskRecord(TaskRecord record) {
        RecordHelper helper = new RecordHelper(this.getWrapper(), record);
        if (this.getWrapper().isSupportBP() && record.threadNum > 1) {
            if (record.isBlock) {
                helper.handleBlockRecord();
            } else {
                helper.handleMultiRecord();
            }
        } else if (!this.getWrapper().isSupportBP()) {
            helper.handleNoSupportBPRecord();
        } else {
            helper.handleSingleThreadRecord();
        }
    }

    public ThreadRecord createThreadRecord(TaskRecord record, int threadId, long startL, long endL) {
        ThreadRecord tr = new ThreadRecord();
        tr.taskKey = record.filePath;
        tr.threadId = threadId;
        tr.startLocation = startL;
        tr.isComplete = false;
        tr.threadType = record.taskType;
        if (threadId == record.threadNum - 1) {
            endL = this.getFileSize();
        }
        tr.endLocation = endL;
        tr.blockLen = RecordUtil.getBlockLen((long)this.getFileSize(), (int)threadId, (int)record.threadNum);
        return tr;
    }

    public TaskRecord createTaskRecord(int threadNum) {
        TaskRecord record = new TaskRecord();
        record.fileName = this.getEntity().getFileName();
        record.filePath = this.getEntity().getFilePath();
        record.threadRecords = new ArrayList();
        record.threadNum = threadNum;
        int requestType = this.getWrapper().getRequestType();
        record.isBlock = requestType == 1 || requestType == 2 ? Configuration.getInstance().downloadCfg.isUseBlock() : false;
        record.taskType = requestType;
        record.isGroupRecord = this.getEntity().isGroupChild();
        if (record.isGroupRecord && this.getEntity() instanceof DownloadEntity) {
            record.dGroupHash = ((DownloadEntity)this.getEntity()).getGroupHash();
        }
        return record;
    }

    public int initTaskThreadNum() {
        int requestTpe = this.getWrapper().getRequestType();
        if (requestTpe == 5 || requestTpe == 1 && !this.getWrapper().isSupportBP() || ((HttpTaskOption)this.getWrapper().getTaskOption()).isChunked()) {
            return 1;
        }
        int threadNum = Configuration.getInstance().downloadCfg.getThreadNum();
        return this.getFileSize() <= 0x100000L || this.getEntity().isGroupChild() || threadNum == 1 ? 1 : threadNum;
    }
}

