/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.testtargetting;

import com.groupcdg.arcmutate.spring.testtargetting.ParentChild;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;

public class ClassHierarchies {
    private final Map<ClassName, List<ClassName>> hierarchy;

    public ClassHierarchies(Map<ClassName, List<ClassName>> hierarchy) {
        this.hierarchy = hierarchy;
    }

    public static ClassHierarchies scan(CodeSource source) {
        Map<ClassName, List<ClassName>> hierarchy = source.codeTrees().flatMap(c -> ClassHierarchies.parents(c)).collect(Collectors.groupingBy(p -> p.parent, Collectors.mapping(s -> s.child, Collectors.toList())));
        return new ClassHierarchies(hierarchy);
    }

    private static Stream<ParentChild> parents(ClassTree c) {
        Stream<Object> superClass = c.rawNode().superName != null ? Stream.of(new ParentChild(ClassName.fromString((String)c.rawNode().superName), c.name())) : Stream.empty();
        Stream<ParentChild> interfaces = c.rawNode().interfaces.stream().map(i -> new ParentChild(ClassName.fromString((String)i), c.name()));
        return Stream.concat(superClass, interfaces);
    }

    public List<ClassName> children(ClassName c) {
        ArrayList<ClassName> collected = new ArrayList<ClassName>();
        this.children(collected, c);
        return collected;
    }

    private void children(List<ClassName> collected, ClassName c) {
        collected.add(c);
        this.hierarchy.getOrDefault(c, Collections.emptyList()).stream().forEach(child -> this.children(collected, (ClassName)child));
    }
}

