/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.mutators;

import com.groupcdg.arcmutate.spring.mutators.Position;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MutationIdentifier;

public class IdEncoder {
    private static final String FIELD_FAKE_DESC = "field";
    private static final String FIELD_CLASS_DESC = "class";
    private final String mutatorBaseId;

    public IdEncoder(String mutatorBaseId) {
        this.mutatorBaseId = mutatorBaseId;
    }

    public MutationIdentifier encodeForClass(ClassName clazz, ClassName annotationType) {
        Location loc = Location.location((ClassName)clazz, (String)clazz.asJavaName(), (String)FIELD_CLASS_DESC);
        return new MutationIdentifier(loc, 1, this.mutatorBaseId + "_" + annotationType);
    }

    public MutationIdentifier encodeForField(ClassName className, String fieldName, ClassName annotationType) {
        Location loc = Location.location((ClassName)className, (String)fieldName, (String)FIELD_FAKE_DESC);
        return new MutationIdentifier(loc, 1, this.mutatorBaseId + "_" + annotationType);
    }

    public MutationIdentifier encodeForMethod(Location location, ClassName annotationType) {
        return new MutationIdentifier(location, 1, this.mutatorBaseId + "_" + annotationType);
    }

    public MutationIdentifier encodeForParameter(Location location, int parameter, ClassName annotationType) {
        return new MutationIdentifier(location, 1, this.mutatorBaseId + "." + parameter + "_" + annotationType);
    }

    public static Position parsePosition(MutationIdentifier id) {
        if (id.getLocation().getMethodDesc().equals(FIELD_CLASS_DESC)) {
            return Position.CLASS;
        }
        if (id.getLocation().getMethodDesc().equals(FIELD_FAKE_DESC)) {
            return Position.FIELD;
        }
        return Position.METHOD_OR_PARAMETER;
    }
}

