/*
 * Decompiled with CFR 0.152.
 */
package com.rainy.networkhelper.util;

import com.google.gson.annotations.SerializedName;
import com.rainy.networkhelper.annotation.HeaderParam;
import com.rainy.networkhelper.annotation.PathParam;
import com.rainy.networkhelper.annotation.QueryParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReflectionUtil {
    public static List<Field> getInheritedPrivateFields(Class<?> type) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : i.getDeclaredFields()) {
                result.add(field);
            }
        }
        return result;
    }

    public static List<Field> getFieldsHavingAnnotation(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : ReflectionUtil.getInheritedPrivateFields(type)) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(annotation)) continue;
            fields.add(field);
        }
        return fields;
    }

    public static List<Field> getMethodsHavingAnnotation(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : ReflectionUtil.getInheritedPrivateFields(type)) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(annotation)) continue;
            fields.add(field);
        }
        return fields;
    }

    public static Annotation getClassAnnotation(Class<?> type, Class<? extends Annotation> annotation) {
        for (Annotation ann : type.getDeclaredAnnotations()) {
            if (!ann.annotationType().equals(annotation)) continue;
            return ann;
        }
        return null;
    }

    public static Map<Method, Annotation> getMethodsAnnotatedWith(Class<?> type, Class<? extends Annotation> annotation) {
        HashMap<Method, Annotation> methods = new HashMap<Method, Annotation>();
        for (Class<?> klass = type; klass != Object.class; klass = klass.getSuperclass()) {
            ArrayList<Method> allMethods = new ArrayList<Method>(Arrays.asList(klass.getDeclaredMethods()));
            for (Method method : allMethods) {
                method.setAccessible(true);
                if (!method.isAnnotationPresent(annotation)) continue;
                Annotation annotInstance = method.getAnnotation(annotation);
                methods.put(method, annotInstance);
            }
        }
        return methods;
    }

    public static String getFieldValue(Field field, Object o) {
        field.setAccessible(true);
        String value = ReflectionUtil.runGetter(field, o);
        if (value == null) {
            try {
                Object obj = field.get(o);
                if (obj != null) {
                    value = obj.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static String runGetter(Field field, Object o) {
        for (Method method : o.getClass().getMethods()) {
            method.setAccessible(true);
            if (!method.getName().startsWith("get") || method.getName().length() != field.getName().length() + 3 || !method.getName().toLowerCase().endsWith(field.getName().toLowerCase())) continue;
            return ReflectionUtil.invokeMethod(method, o);
        }
        return null;
    }

    public static String invokeMethod(Method method, Object receiver) {
        try {
            Object o = method.invoke(receiver, new Object[0]);
            if (o != null) {
                return o.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Map<String, String> convertObjectToMap(Object object) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<Field> fieldList = ReflectionUtil.getInheritedPrivateFields(object.getClass());
        for (Field field : fieldList) {
            String value;
            if (field.isAnnotationPresent(HeaderParam.class)) continue;
            String key = field.getName();
            SerializedName ann = field.getAnnotation(SerializedName.class);
            if (ann != null) {
                key = ann.value();
            }
            if ((value = ReflectionUtil.getFieldValue(field, object)) == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, String> getMethodsAndFieldValuesAnnotatedWithHeaderParam(Object o) {
        String value;
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Field field : ReflectionUtil.getFieldsHavingAnnotation(o.getClass(), HeaderParam.class)) {
            field.setAccessible(true);
            HeaderParam headerParamAnnotation = field.getAnnotation(HeaderParam.class);
            if (headerParamAnnotation == null) continue;
            String fieldName = field.getName();
            if (!headerParamAnnotation.name().equals("")) {
                fieldName = headerParamAnnotation.name();
            }
            if ((value = ReflectionUtil.getFieldValue(field, o)) == null) continue;
            headers.put(fieldName, value);
        }
        for (Map.Entry entry : ReflectionUtil.getMethodsAnnotatedWith(o.getClass(), HeaderParam.class).entrySet()) {
            String fieldName = ((Method)entry.getKey()).getName();
            HeaderParam headerParamAnnotation = (HeaderParam)entry.getValue();
            if (headerParamAnnotation.name() != null && headerParamAnnotation.name().length() != 0) {
                fieldName = headerParamAnnotation.name();
            } else if (fieldName.startsWith("get") && fieldName.length() > 3) {
                fieldName = fieldName.substring(3);
                char[] c = fieldName.toCharArray();
                c[0] = Character.toLowerCase(c[0]);
                fieldName = new String(c);
            }
            if ((value = ReflectionUtil.invokeMethod((Method)entry.getKey(), o)) == null) continue;
            headers.put(fieldName, value);
        }
        return headers;
    }

    public static Map<String, String> getMethodsAndFieldValuesAnnotatedWithPathParam(Object o) {
        String value;
        HashMap<String, String> items = new HashMap<String, String>();
        for (Field field : ReflectionUtil.getFieldsHavingAnnotation(o.getClass(), PathParam.class)) {
            field.setAccessible(true);
            PathParam headerParamAnnotation = field.getAnnotation(PathParam.class);
            if (headerParamAnnotation == null) continue;
            String fieldName = field.getName();
            if (!headerParamAnnotation.name().equals("")) {
                fieldName = headerParamAnnotation.name();
            }
            if ((value = ReflectionUtil.getFieldValue(field, o)) == null) continue;
            items.put(fieldName, value);
        }
        for (Map.Entry entry : ReflectionUtil.getMethodsAnnotatedWith(o.getClass(), PathParam.class).entrySet()) {
            String fieldName = ((Method)entry.getKey()).getName();
            PathParam headerParamAnnotation = (PathParam)entry.getValue();
            if (headerParamAnnotation.name() != null && headerParamAnnotation.name().length() != 0) {
                fieldName = headerParamAnnotation.name();
            } else if (fieldName.startsWith("get") && fieldName.length() > 3) {
                fieldName = fieldName.substring(3);
                char[] c = fieldName.toCharArray();
                c[0] = Character.toLowerCase(c[0]);
                fieldName = new String(c);
            }
            if ((value = ReflectionUtil.invokeMethod((Method)entry.getKey(), o)) == null) continue;
            items.put(fieldName, value);
        }
        return items;
    }

    public static Map<String, String> getMethodsAndFieldValuesAnnotatedWithQueryParam(Object o) {
        String value;
        HashMap<String, String> items = new HashMap<String, String>();
        for (Field field : ReflectionUtil.getFieldsHavingAnnotation(o.getClass(), QueryParam.class)) {
            field.setAccessible(true);
            QueryParam headerParamAnnotation = field.getAnnotation(QueryParam.class);
            if (headerParamAnnotation == null) continue;
            String fieldName = field.getName();
            if (!headerParamAnnotation.name().equals("")) {
                fieldName = headerParamAnnotation.name();
            }
            if ((value = ReflectionUtil.getFieldValue(field, o)) == null) continue;
            items.put(fieldName, value);
        }
        for (Map.Entry entry : ReflectionUtil.getMethodsAnnotatedWith(o.getClass(), QueryParam.class).entrySet()) {
            String fieldName = ((Method)entry.getKey()).getName();
            QueryParam headerParamAnnotation = (QueryParam)entry.getValue();
            if (headerParamAnnotation.name() != null && headerParamAnnotation.name().length() != 0) {
                fieldName = headerParamAnnotation.name();
            } else if (fieldName.startsWith("get") && fieldName.length() > 3) {
                fieldName = fieldName.substring(3);
                char[] c = fieldName.toCharArray();
                c[0] = Character.toLowerCase(c[0]);
                fieldName = new String(c);
            }
            if ((value = ReflectionUtil.invokeMethod((Method)entry.getKey(), o)) == null) continue;
            items.put(fieldName, value);
        }
        return items;
    }
}

