/*
 * Decompiled with CFR 0.152.
 */
package com.rainy.networkhelper.future;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class ExecutionFuture<T>
implements Future<T> {
    private static final ExecutorService sExecutorService = Executors.newFixedThreadPool(4);
    private static final Handler handler = new Handler(Looper.getMainLooper());
    private ExecutorService executorService;
    private volatile OnProgressChangedListener onProgressChangedListener;
    private volatile OnSuccessListener<T> onSuccessListener;
    private volatile OnErrorListener onErrorListener;
    private volatile boolean cancelled = false;
    private volatile boolean done = false;
    private final Object lock = new Object();

    public ExecutionFuture() {
        this.executorService = sExecutorService;
    }

    public ExecutionFuture(ExecutorService executorService) {
        this.executorService = executorService;
    }

    protected abstract T execute(Long var1) throws Exception;

    public void enqueue(OnSuccessListener<T> onSuccessListener, OnErrorListener onErrorListener) {
        this.onSuccessListener = onSuccessListener;
        this.onErrorListener = onErrorListener;
        this.cancelled = false;
        this.executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    final Object result = ExecutionFuture.this.execute(null);
                    Object object = ExecutionFuture.this.lock;
                    synchronized (object) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (ExecutionFuture.this.onSuccessListener != null && !ExecutionFuture.this.cancelled) {
                                    ExecutionFuture.this.onSuccessListener.onSuccess(result);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Object object = ExecutionFuture.this.lock;
                    synchronized (object) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (ExecutionFuture.this.onErrorListener != null && !ExecutionFuture.this.cancelled) {
                                    ExecutionFuture.this.onErrorListener.onError(e);
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    public ExecutionFuture<T> withProgressChangedListener(OnProgressChangedListener onProgressChangedListener) {
        this.onProgressChangedListener = onProgressChangedListener;
        return this;
    }

    protected void updateProgress(final float progress, final String message) {
        if (this.onProgressChangedListener != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    ExecutionFuture.this.onProgressChangedListener.onProgressChanged(progress, message);
                }
            });
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.lock;
        synchronized (object) {
            this.onSuccessListener = null;
            this.onErrorListener = null;
            this.onProgressChangedListener = null;
            this.cancelled = true;
            return !this.done;
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        try {
            T result = this.execute(null);
            this.done = true;
            return result;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public final T get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.execute(TimeUnit.MILLISECONDS.convert(timeout, timeUnit));
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public static interface OnErrorListener {
        public void onError(Exception var1);
    }

    public static interface OnSuccessListener<T> {
        public void onSuccess(T var1);
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(float var1, String var2);
    }
}

