/*
 * Decompiled with CFR 0.152.
 */
package com.rainy.networkhelper.mapper;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import com.rainy.networkhelper.annotation.HeaderParam;
import com.rainy.networkhelper.mapper.BodyMapper;
import java.lang.reflect.Type;

public class GsonBodyMapper
implements BodyMapper {
    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExcludeHeaderStrategy()});
    }

    @Override
    public byte[] encodeParams(Object object, String encoding) throws Exception {
        return this.getGsonBuilder().create().toJson(object).getBytes(encoding);
    }

    @Override
    public <T> T decodeParams(byte[] data, Class<T> clazz, String encoding) throws Exception {
        String json = new String(data, encoding);
        return (T)this.getGsonBuilder().create().fromJson(json, clazz);
    }

    @Override
    public <T> T decodeParams(byte[] data, Type type, String encoding) throws Exception {
        String json = new String(data, encoding);
        return (T)this.getGsonBuilder().create().fromJson(json, type);
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    public class ExcludeHeaderStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(HeaderParam.class) != null;
        }
    }
}

