/*
 * Decompiled with CFR 0.152.
 */
package com.rainy.networkhelper.request;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsyncRequestFuture<T>
implements Future<T>,
Response.Listener<T>,
Response.ErrorListener {
    protected Request<T> mRequest;
    protected boolean mResultReceived = false;
    protected T mResult;
    protected VolleyError mException;
    private Response.Listener<T> mListener;
    private Response.ErrorListener mErrorListener;

    protected AsyncRequestFuture() {
    }

    protected AsyncRequestFuture(Request<T> request) {
        this.mRequest = request;
    }

    public static <E> AsyncRequestFuture<E> newFuture() {
        return new AsyncRequestFuture();
    }

    public static <E> AsyncRequestFuture<E> newFuture(Request<E> request) {
        return new AsyncRequestFuture<E>(request);
    }

    public void setRequest(Request<T> mRequest) {
        this.mRequest = mRequest;
    }

    public Request<?> getRequest() {
        return this.mRequest;
    }

    public void setListeners(Response.Listener<T> listener, Response.ErrorListener errorListener) {
        this.mListener = listener;
        this.mErrorListener = errorListener;
        if (!this.isCancelled()) {
            if (this.mResult != null) {
                listener.onResponse(this.mResult);
            } else if (this.mException != null) {
                errorListener.onErrorResponse(this.mException);
            }
        }
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.mRequest == null) {
            return false;
        }
        if (!this.isDone()) {
            this.mRequest.cancel();
            return true;
        }
        return false;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.doGet(null);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doGet(TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    protected synchronized T doGet(Long timeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.mException != null) {
            throw new ExecutionException((Throwable)this.mException);
        }
        if (this.mResultReceived) {
            return this.mResult;
        }
        if (timeoutMs == null) {
            this.wait(0L);
        } else if (timeoutMs > 0L) {
            this.wait(timeoutMs);
        }
        if (this.mException != null) {
            throw new ExecutionException((Throwable)this.mException);
        }
        if (!this.mResultReceived) {
            throw new TimeoutException();
        }
        return this.mResult;
    }

    @Override
    public boolean isCancelled() {
        if (this.mRequest == null) {
            return false;
        }
        return this.mRequest.isCanceled();
    }

    @Override
    public synchronized boolean isDone() {
        return this.mResultReceived || this.mException != null || this.isCancelled();
    }

    public synchronized void onResponse(T response) {
        this.mResultReceived = true;
        this.mResult = response;
        this.notifyAll();
        if (this.mListener != null) {
            this.mListener.onResponse(response);
        }
    }

    public synchronized void onErrorResponse(VolleyError error) {
        this.mException = error;
        this.notifyAll();
        if (this.mErrorListener != null) {
            this.mErrorListener.onErrorResponse(error);
        }
    }
}

