package com.appspiriment.baseclasses

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.AsyncDifferConfig
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView
import java.util.concurrent.Executors

/*********************************************************
 * Class   :  BaseAdapter
 *******************************************************
 * Purpose :  Acts as a baseclass for RecyclerView Adapters
 *******************************************************
 * Rework Details:
 * 1) {Author} :  {Date} : {Details}
 *********************************************************/
abstract class BaseListAdapter<ListItemType, ViewBindingType : ViewDataBinding>(
    private val itemLayoutId: Int,
    diffCallback: DiffUtil.ItemCallback<ListItemType> = object :
        DiffUtil.ItemCallback<ListItemType>() {
        override fun areItemsTheSame(oldItem: ListItemType, newItem: ListItemType) = false
        override fun areContentsTheSame(oldItem: ListItemType, newItem: ListItemType) = false
    }
) : ListAdapter<ListItemType, BaseListAdapter<ListItemType, ViewBindingType>.BaseViewHolder>(
    AsyncDifferConfig.Builder<ListItemType>(diffCallback)
        .setBackgroundThreadExecutor(Executors.newSingleThreadExecutor())
        .build()
) {

    /***************************************
     * Declarations
     ***************************************/
    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): BaseViewHolder {
        val layoutInflater = LayoutInflater.from(parent.context)

        val binding = DataBindingUtil.inflate<ViewBindingType>(
            layoutInflater,
            itemLayoutId,
            parent,
            false
        )
        return BaseViewHolder(binding)
    }

    /***************************************
     * Declarations
     ***************************************/
    override fun onBindViewHolder(holder: BaseViewHolder, position: Int) {
        onBind(holder.binding, getItem(position), position)
    }

    open fun onBind(binding : ViewBindingType, item : ListItemType, position: Int){}

    /***************************************
     * Declarations
     ***************************************/
    open inner class BaseViewHolder constructor(val binding: ViewBindingType) :
        RecyclerView.ViewHolder(binding.root)
}

