/*
 * Decompiled with CFR 0.152.
 */
package com.appspiriment.androidutils;

import android.text.format.DateUtils;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004J\n\u0010\n\u001a\u00020\u0004*\u00020\u000bJ\n\u0010\f\u001a\u00020\u0004*\u00020\rJ\n\u0010\f\u001a\u00020\u0004*\u00020\u000bJ2\u0010\u000e\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Lcom/appspiriment/androidutils/FormatUtils;", "", "()V", "formatToKmgFormat", "", "num", "", "changeDateFormat", "inputFormat", "outputFormat", "formatMillisToTime", "", "toKmgFormat", "", "toRelativeDateString", "span", "maxSpan", "androidutils_release"})
public final class FormatUtils {
    public static final FormatUtils INSTANCE;

    @NotNull
    public final String formatMillisToTime(long $this$formatMillisToTime) {
        Object object;
        try {
            object = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
            Locale locale2 = locale;
            String string = "%02d:%02d";
            Object[] objectArray = new Object[]{TimeUnit.MILLISECONDS.toMinutes($this$formatMillisToTime) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours($this$formatMillisToTime)), TimeUnit.MILLISECONDS.toSeconds($this$formatMillisToTime) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes($this$formatMillisToTime))};
            boolean bl = false;
            String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            object = string2;
        }
        catch (Exception e) {
            return String.valueOf($this$formatMillisToTime);
        }
        return object;
    }

    @NotNull
    public final String toKmgFormat(int $this$toKmgFormat) {
        return this.formatToKmgFormat($this$toKmgFormat);
    }

    @NotNull
    public final String toKmgFormat(long $this$toKmgFormat) {
        return this.formatToKmgFormat($this$toKmgFormat);
    }

    private final String formatToKmgFormat(Number num) {
        NumberFormat formatter;
        NumberFormat numberFormat = formatter = NumberFormat.getNumberInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"formatter");
        numberFormat.setMaximumFractionDigits(1);
        Map kmgMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)1000000000L, (Object)"G"), TuplesKt.to((Object)1000000L, (Object)"M"), TuplesKt.to((Object)1000L, (Object)"K")});
        Iterable $this$forEach$iv = kmgMap.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            if (num.longValue() < it) continue;
            float numQnt = num.floatValue() / (float)it;
            return formatter.format(numQnt) + (String)kmgMap.get(it);
        }
        return num.toString();
    }

    @NotNull
    public final String toRelativeDateString(@NotNull String $this$toRelativeDateString, long span, int maxSpan, @NotNull String inputFormat, @NotNull String outputFormat) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$toRelativeDateString, (String)"$this$toRelativeDateString");
        Intrinsics.checkParameterIsNotNull((Object)inputFormat, (String)"inputFormat");
        Intrinsics.checkParameterIsNotNull((Object)outputFormat, (String)"outputFormat");
        try {
            String string2;
            Date date1 = new SimpleDateFormat(inputFormat, Locale.ENGLISH).parse($this$toRelativeDateString);
            long now = System.currentTimeMillis();
            long diffInMillisec = now - date1.getTime();
            long diffInDays = TimeUnit.MILLISECONDS.toDays(diffInMillisec);
            if (diffInDays > (long)maxSpan) {
                String string3 = new SimpleDateFormat(outputFormat, Locale.ENGLISH).format(date1);
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"SimpleDateFormat(outputF\u2026le.ENGLISH).format(date1)");
            } else {
                string2 = ((Object)DateUtils.getRelativeTimeSpanString((long)date1.getTime(), (long)now, (long)span)).toString();
            }
            string = string2;
        }
        catch (Exception e) {
            string = $this$toRelativeDateString;
        }
        return string;
    }

    public static /* synthetic */ String toRelativeDateString$default(FormatUtils formatUtils, String string, long l, int n, String string2, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l = 86400000L;
        }
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            string2 = "yyyy-MM-dd";
        }
        if ((n2 & 8) != 0) {
            string3 = "dd MMM yyyy";
        }
        return formatUtils.toRelativeDateString(string, l, n, string2, string3);
    }

    @NotNull
    public final String changeDateFormat(@NotNull String $this$changeDateFormat, @NotNull String inputFormat, @NotNull String outputFormat) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$changeDateFormat, (String)"$this$changeDateFormat");
        Intrinsics.checkParameterIsNotNull((Object)inputFormat, (String)"inputFormat");
        Intrinsics.checkParameterIsNotNull((Object)outputFormat, (String)"outputFormat");
        try {
            Date date1 = new SimpleDateFormat(inputFormat, Locale.ENGLISH).parse($this$changeDateFormat);
            String string2 = new SimpleDateFormat(outputFormat, Locale.ENGLISH).format(date1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SimpleDateFormat(outputF\u2026le.ENGLISH).format(date1)");
            string = string2;
        }
        catch (Exception e) {
            string = $this$changeDateFormat;
        }
        return string;
    }

    public static /* synthetic */ String changeDateFormat$default(FormatUtils formatUtils, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "yyyy-MM-dd";
        }
        if ((n & 2) != 0) {
            string3 = "dd MMM yyyy";
        }
        return formatUtils.changeDateFormat(string, string2, string3);
    }

    private FormatUtils() {
    }

    static {
        FormatUtils formatUtils;
        INSTANCE = formatUtils = new FormatUtils();
    }
}

