/*
 * Decompiled with CFR 0.152.
 */
package com.appspiriment.androidutils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.Priority;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.StringRequestListener;
import com.appspiriment.androidutils.LogUtils;
import com.appspiriment.androidutils.NetworkUtils;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u007f\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u00142\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00100\u00142\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00100\u00142#\b\u0002\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00100\u00142\b\b\u0002\u0010\u001e\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/appspiriment/androidutils/NetworkUtils;", "", "()V", "API_REQUEST_JSON", "", "getAPI_REQUEST_JSON", "()I", "API_REQUEST_JSON_ARRAY", "getAPI_REQUEST_JSON_ARRAY", "API_REQUEST_STRING", "getAPI_REQUEST_STRING", "isNetworkConnected", "", "context", "Landroid/content/Context;", "startApiRequest", "", "url", "", "stringSuccessListener", "Lkotlin/Function1;", "jsonSuccessListener", "Lorg/json/JSONObject;", "jsonArraySuccessListener", "Lorg/json/JSONArray;", "errorListen", "Lcom/androidnetworking/error/ANError;", "Lkotlin/ParameterName;", "name", "error", "requestType", "androidutils_release"})
public final class NetworkUtils {
    private static final int API_REQUEST_STRING = 101;
    private static final int API_REQUEST_JSON = 102;
    private static final int API_REQUEST_JSON_ARRAY = 103;
    public static final NetworkUtils INSTANCE;

    public final int getAPI_REQUEST_STRING() {
        return API_REQUEST_STRING;
    }

    public final int getAPI_REQUEST_JSON() {
        return API_REQUEST_JSON;
    }

    public final int getAPI_REQUEST_JSON_ARRAY() {
        return API_REQUEST_JSON_ARRAY;
    }

    public final boolean isNetworkConnected(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connMgr = (ConnectivityManager)object;
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public final void startApiRequest(@NotNull String url, @NotNull Function1<? super String, Unit> stringSuccessListener, @NotNull Function1<? super JSONObject, Unit> jsonSuccessListener, @NotNull Function1<? super JSONArray, Unit> jsonArraySuccessListener, @NotNull Function1<? super ANError, Unit> errorListen, int requestType) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(stringSuccessListener, (String)"stringSuccessListener");
        Intrinsics.checkParameterIsNotNull(jsonSuccessListener, (String)"jsonSuccessListener");
        Intrinsics.checkParameterIsNotNull(jsonArraySuccessListener, (String)"jsonArraySuccessListener");
        Intrinsics.checkParameterIsNotNull(errorListen, (String)"errorListen");
        LogUtils.printLog$default(LogUtils.INSTANCE, " URL   " + url, null, false, 6, null);
        OkHttpClient okHttpClient = new OkHttpClient().newBuilder().connectTimeout(3L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).build();
        ANRequest aNRequest = AndroidNetworking.get((String)url).setPriority(Priority.MEDIUM).setOkHttpClient(okHttpClient).build();
        boolean bl = false;
        boolean bl2 = false;
        ANRequest $this$apply = aNRequest;
        boolean bl3 = false;
        int n = requestType;
        if (n == API_REQUEST_JSON_ARRAY) {
            $this$apply.getAsJSONArray(new JSONArrayRequestListener(requestType, jsonArraySuccessListener, errorListen, jsonSuccessListener, stringSuccessListener){
                final /* synthetic */ int $requestType$inlined;
                final /* synthetic */ Function1 $jsonArraySuccessListener$inlined;
                final /* synthetic */ Function1 $errorListen$inlined;
                final /* synthetic */ Function1 $jsonSuccessListener$inlined;
                final /* synthetic */ Function1 $stringSuccessListener$inlined;
                {
                    this.$requestType$inlined = n;
                    this.$jsonArraySuccessListener$inlined = function1;
                    this.$errorListen$inlined = function12;
                    this.$jsonSuccessListener$inlined = function13;
                    this.$stringSuccessListener$inlined = function14;
                }

                public void onResponse(@NotNull JSONArray response) {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    this.$jsonArraySuccessListener$inlined.invoke((Object)response);
                }

                public void onError(@NotNull ANError error) {
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    this.$errorListen$inlined.invoke((Object)error);
                }
            });
        } else if (n == API_REQUEST_JSON) {
            $this$apply.getAsJSONObject(new JSONObjectRequestListener(requestType, jsonArraySuccessListener, errorListen, jsonSuccessListener, stringSuccessListener){
                final /* synthetic */ int $requestType$inlined;
                final /* synthetic */ Function1 $jsonArraySuccessListener$inlined;
                final /* synthetic */ Function1 $errorListen$inlined;
                final /* synthetic */ Function1 $jsonSuccessListener$inlined;
                final /* synthetic */ Function1 $stringSuccessListener$inlined;
                {
                    this.$requestType$inlined = n;
                    this.$jsonArraySuccessListener$inlined = function1;
                    this.$errorListen$inlined = function12;
                    this.$jsonSuccessListener$inlined = function13;
                    this.$stringSuccessListener$inlined = function14;
                }

                public void onResponse(@NotNull JSONObject response) {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    this.$jsonSuccessListener$inlined.invoke((Object)response);
                }

                public void onError(@NotNull ANError error) {
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    this.$errorListen$inlined.invoke((Object)error);
                }
            });
        } else {
            $this$apply.getAsString(new StringRequestListener(requestType, jsonArraySuccessListener, errorListen, jsonSuccessListener, stringSuccessListener){
                final /* synthetic */ int $requestType$inlined;
                final /* synthetic */ Function1 $jsonArraySuccessListener$inlined;
                final /* synthetic */ Function1 $errorListen$inlined;
                final /* synthetic */ Function1 $jsonSuccessListener$inlined;
                final /* synthetic */ Function1 $stringSuccessListener$inlined;
                {
                    this.$requestType$inlined = n;
                    this.$jsonArraySuccessListener$inlined = function1;
                    this.$errorListen$inlined = function12;
                    this.$jsonSuccessListener$inlined = function13;
                    this.$stringSuccessListener$inlined = function14;
                }

                public void onResponse(@NotNull String response) {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    this.$stringSuccessListener$inlined.invoke((Object)response);
                }

                public void onError(@NotNull ANError anError) {
                    Intrinsics.checkParameterIsNotNull((Object)anError, (String)"anError");
                    this.$errorListen$inlined.invoke((Object)anError);
                }
            });
        }
    }

    public static /* synthetic */ void startApiRequest$default(NetworkUtils networkUtils, String string, Function1 function1, Function1 function12, Function1 function13, Function1 function14, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = startApiRequest.1.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            function12 = startApiRequest.2.INSTANCE;
        }
        if ((n2 & 8) != 0) {
            function13 = startApiRequest.3.INSTANCE;
        }
        if ((n2 & 0x10) != 0) {
            function14 = startApiRequest.4.INSTANCE;
        }
        if ((n2 & 0x20) != 0) {
            n = API_REQUEST_STRING;
        }
        networkUtils.startApiRequest(string, (Function1<? super String, Unit>)function1, (Function1<? super JSONObject, Unit>)function12, (Function1<? super JSONArray, Unit>)function13, (Function1<? super ANError, Unit>)function14, n);
    }

    private NetworkUtils() {
    }

    static {
        NetworkUtils networkUtils;
        INSTANCE = networkUtils = new NetworkUtils();
        API_REQUEST_STRING = 101;
        API_REQUEST_JSON = 102;
        API_REQUEST_JSON_ARRAY = 103;
    }
}

