/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.oaid;

import android.content.Context;
import android.os.Build;
import androidx.annotation.Nullable;
import com.appsflyer.oaid.OaidMsaClient;
import com.bun.miitmdid.interfaces.IIdentifierListener;
import com.huawei.hms.ads.identifier.AdvertisingIdClient;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OaidClient {
    private final Logger logger = Logger.getLogger("AppsFlyerOaid6.12.3");
    private final Context context;
    private final long timeout;
    private final TimeUnit unit;

    public OaidClient(Context context, long timeout, TimeUnit unit) {
        this.context = context;
        this.timeout = timeout;
        this.unit = unit;
        this.logger.setLevel(Level.OFF);
    }

    public OaidClient(Context context) {
        this(context, 1L, TimeUnit.SECONDS);
    }

    private static boolean isHuawei() {
        try {
            return Build.BRAND.equalsIgnoreCase("huawei") || (Integer)Class.forName("com.huawei.android.os.BuildEx$VERSION").getDeclaredField("EMUI_SDK_INT").get(null) > 0;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        catch (NoSuchFieldException ignored) {
            return false;
        }
        catch (IllegalAccessException ignored) {
            return false;
        }
    }

    private static boolean isMsaAvailableAtRuntime() {
        try {
            IIdentifierListener.class.getName();
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Nullable
    public Info fetch() {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        try {
            long current = System.currentTimeMillis();
            Info info = OaidClient.isHuawei() ? this.fetchHuawei() : (OaidClient.isMsaAvailableAtRuntime() ? OaidMsaClient.fetchMsa(this.context, this.logger, this.timeout, this.unit) : null);
            this.logger.info("Fetch " + (System.currentTimeMillis() - current) + " ms");
            return info;
        }
        catch (Throwable t) {
            this.logger.info(t.getMessage());
            return null;
        }
    }

    @Nullable
    private Info fetchHuawei() {
        try {
            if (OaidClient.isMsaAvailableAtRuntime()) {
                OaidMsaClient.loadNativeLibrary();
            }
            FutureTask<Info> task = new FutureTask<Info>(new Callable<Info>(){

                @Override
                public Info call() {
                    AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)OaidClient.this.context);
                    if (info == null) {
                        return null;
                    }
                    return new Info(info.getId(), info.isLimitAdTrackingEnabled());
                }
            });
            new Thread(task).start();
            return task.get(this.timeout, this.unit);
        }
        catch (Throwable t) {
            this.logger.info(t.getMessage());
            return null;
        }
    }

    public void setLogging(boolean logging) {
        this.logger.setLevel(logging ? null : Level.OFF);
    }

    public static class Info {
        private final Boolean lat;
        private final String id;

        public Info(String id, Boolean lat) {
            this.id = id;
            this.lat = lat;
        }

        public String getId() {
            return this.id;
        }

        @Nullable
        public Boolean getLat() {
            return this.lat;
        }
    }
}

