/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.resolver;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.appsflyer.resolver.AFHttpResponse;
import com.appsflyer.resolver.ExtensionsKt;
import com.appsflyer.resolver.URLResolver;
import com.appsflyer.resolver.URLResolverListener;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ9\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122'\u0010\u001f\u001a#\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0006\u0012\u0004\u0018\u00010\u00120 j\u0002`%H\u0002J\u0018\u0010&\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001bJE\u0010'\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001b2)\u0010(\u001a%\u0012\u0015\u0012\u0013\u0018\u00010\u0012\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u001d0 j\u0002`)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/appsflyer/resolver/URLResolver;", "", "debug", "", "handler", "Landroid/os/Handler;", "(ZLandroid/os/Handler;)V", "(Z)V", "executors", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getExecutors", "()Ljava/util/concurrent/ExecutorService;", "executors$delegate", "Lkotlin/Lazy;", "afDebugLog", "", "msg", "", "afErrorLog", "e", "", "resolve", "url", "maxRedirections", "", "urlResolverListener", "Lcom/appsflyer/resolver/URLResolverListener;", "resolveInternal", "Lcom/appsflyer/resolver/AFHttpResponse;", "uri", "logic", "Lkotlin/Function1;", "Ljava/net/HttpURLConnection;", "Lkotlin/ParameterName;", "name", "connection", "Lcom/appsflyer/resolver/LookForRedirect;", "resolveJSRedirection", "startResolvingJob", "job", "Lcom/appsflyer/resolver/ResolveJob;", "AppsFlyerURLResolverLib_release"})
public final class URLResolver {
    private final boolean debug;
    @NotNull
    private final Handler handler;
    @NotNull
    private final Lazy executors$delegate;

    private final ExecutorService getExecutors() {
        Lazy lazy = this.executors$delegate;
        return (ExecutorService)lazy.getValue();
    }

    @VisibleForTesting
    public URLResolver(boolean debug, @NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.executors$delegate = LazyKt.lazy((Function0)executors.2.INSTANCE);
        CookieHandler.setDefault(new CookieManager());
        this.debug = debug;
        this.handler = handler;
    }

    public /* synthetic */ URLResolver(boolean bl, Handler handler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl, handler);
    }

    public URLResolver(boolean debug) {
        this(debug, new Handler(Looper.getMainLooper()));
    }

    public /* synthetic */ URLResolver(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final void resolve(@Nullable String url, int maxRedirections, @NotNull URLResolverListener urlResolverListener) {
        Intrinsics.checkNotNullParameter((Object)urlResolverListener, (String)"urlResolverListener");
        this.startResolvingJob(url, urlResolverListener, (Function1<? super String, AFHttpResponse>)((Function1)new Function1<String, AFHttpResponse>(maxRedirections, this){
            final /* synthetic */ int $maxRedirections;
            final /* synthetic */ URLResolver this$0;
            {
                this.$maxRedirections = $maxRedirections;
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final AFHttpResponse invoke(@Nullable String it) {
                AFHttpResponse aFHttpResponse;
                String string = it;
                if (string != null) {
                    String string2 = string;
                    int n = this.$maxRedirections;
                    URLResolver uRLResolver = this.this$0;
                    String $this$invoke_u24lambda_u2d2 = string2;
                    boolean bl = false;
                    String redirect = null;
                    redirect = $this$invoke_u24lambda_u2d2;
                    AFHttpResponse res = null;
                    for (int i = 0; i < n; ++i) {
                        Unit unit;
                        res = URLResolver.access$resolveInternal(uRLResolver, redirect, (Function1)new Function1<HttpURLConnection, String>(uRLResolver){
                            final /* synthetic */ URLResolver this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @Nullable
                            public final String invoke(@NotNull HttpURLConnection con) {
                                String string;
                                Intrinsics.checkNotNullParameter((Object)con, (String)"con");
                                if (ExtensionsKt.isRedirected(con)) {
                                    String string2 = ExtensionsKt.getRedirectedTo(con);
                                    URLResolver uRLResolver = this.this$0;
                                    String l = string2;
                                    boolean bl = false;
                                    URLResolver.access$afDebugLog(uRLResolver, "redirecting to " + l);
                                    string = string2;
                                } else {
                                    string = null;
                                }
                                return string;
                            }
                        });
                        if (res.getRedirected() != null) {
                            String r;
                            boolean bl2 = false;
                            redirect = r;
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        if (unit == null) break;
                    }
                    AFHttpResponse aFHttpResponse2 = res;
                    if (aFHttpResponse2 != null) {
                        AFHttpResponse aFHttpResponse3;
                        AFHttpResponse $this$invoke_u24lambda_u2d2_u24lambda_u2d1 = aFHttpResponse3 = aFHttpResponse2;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u2d2_u24lambda_u2d1.setRedirected(redirect);
                        aFHttpResponse = aFHttpResponse3;
                    } else {
                        aFHttpResponse = null;
                    }
                } else {
                    aFHttpResponse = null;
                }
                return aFHttpResponse;
            }
        }));
    }

    public static /* synthetic */ void resolve$default(URLResolver uRLResolver, String string, int n, URLResolverListener uRLResolverListener, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        uRLResolver.resolve(string, n, uRLResolverListener);
    }

    public final void resolveJSRedirection(@Nullable String url, @NotNull URLResolverListener urlResolverListener) {
        Intrinsics.checkNotNullParameter((Object)urlResolverListener, (String)"urlResolverListener");
        this.startResolvingJob(url, urlResolverListener, (Function1<? super String, AFHttpResponse>)((Function1)new Function1<String, AFHttpResponse>(this){
            final /* synthetic */ URLResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final AFHttpResponse invoke(@Nullable String it) {
                AFHttpResponse aFHttpResponse;
                String string = it;
                if (string != null) {
                    String string2 = string;
                    URLResolver uRLResolver = this.this$0;
                    String $this$invoke_u24lambda_u2d0 = string2;
                    boolean bl = false;
                    aFHttpResponse = URLResolver.access$resolveInternal(uRLResolver, $this$invoke_u24lambda_u2d0, resolveJSRedirection.1.1.INSTANCE);
                } else {
                    aFHttpResponse = null;
                }
                return aFHttpResponse;
            }
        }));
    }

    private final void startResolvingJob(String url, URLResolverListener urlResolverListener, Function1<? super String, AFHttpResponse> job) {
        this.getExecutors().submit(() -> URLResolver.startResolvingJob$lambda-4(url, urlResolverListener, this, job));
    }

    private final AFHttpResponse resolveInternal(String uri, Function1<? super HttpURLConnection, String> logic) {
        AFHttpResponse res = new AFHttpResponse(null, null, null, 7, null);
        try {
            AFHttpResponse aFHttpResponse;
            HttpURLConnection $this$resolveInternal_u24lambda_u2d6 = ExtensionsKt.openHttpURLConnection(uri);
            boolean bl = false;
            $this$resolveInternal_u24lambda_u2d6.setInstanceFollowRedirects(false);
            $this$resolveInternal_u24lambda_u2d6.setReadTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            $this$resolveInternal_u24lambda_u2d6.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            int responseCode = $this$resolveInternal_u24lambda_u2d6.getResponseCode();
            AFHttpResponse $this$resolveInternal_u24lambda_u2d6_u24lambda_u2d5 = aFHttpResponse = res;
            boolean bl2 = false;
            $this$resolveInternal_u24lambda_u2d6_u24lambda_u2d5.setStatus(responseCode);
            $this$resolveInternal_u24lambda_u2d6_u24lambda_u2d5.setRedirected((String)logic.invoke((Object)$this$resolveInternal_u24lambda_u2d6));
            $this$resolveInternal_u24lambda_u2d6.disconnect();
        }
        catch (Throwable e) {
            res.setError(e.getLocalizedMessage());
            this.afErrorLog(e.getMessage(), e);
        }
        return res;
    }

    private final void afDebugLog(String msg) {
        if (this.debug) {
            Log.d((String)"AppsFlyer_Resolver", (String)msg);
        }
    }

    private final void afErrorLog(String msg, Throwable e) {
        if (msg != null) {
            Log.e((String)"AppsFlyer_Resolver", (String)msg);
        }
        e.printStackTrace();
    }

    private static final void startResolvingJob$lambda-4(String $url, URLResolverListener $urlResolverListener, URLResolver this$0, Function1 $job) {
        block13: {
            Object object;
            block9: {
                AFHttpResponse aFHttpResponse;
                block12: {
                    String it;
                    block10: {
                        block11: {
                            Unit unit;
                            AFHttpResponse aFHttpResponse2;
                            Intrinsics.checkNotNullParameter((Object)$urlResolverListener, (String)"$urlResolverListener");
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
                            object = $url;
                            if (object == null) break block9;
                            it = object;
                            boolean bl = false;
                            this$0.afDebugLog("resolving " + it);
                            if (!ExtensionsKt.isValidURL(it)) break block10;
                            aFHttpResponse = (AFHttpResponse)$job.invoke((Object)it);
                            if (aFHttpResponse == null) break block11;
                            AFHttpResponse $this$startResolvingJob_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2 = aFHttpResponse2 = aFHttpResponse;
                            boolean bl2 = false;
                            String string = $this$startResolvingJob_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.getError();
                            if (string != null) {
                                String it2 = string;
                                boolean bl3 = false;
                                ExtensionsKt.executeOnCompleteOnMainThread($urlResolverListener, null, this$0.handler);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            if (unit == null) {
                                String $this$startResolvingJob_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 = $this$startResolvingJob_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.getRedirected();
                                boolean bl4 = false;
                                this$0.afDebugLog("found link: " + $this$startResolvingJob_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1);
                                ExtensionsKt.executeOnCompleteOnMainThread($urlResolverListener, $this$startResolvingJob_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1, this$0.handler);
                            }
                            if ((aFHttpResponse = aFHttpResponse2) != null) break block12;
                        }
                        ExtensionsKt.executeOnCompleteOnMainThread($urlResolverListener, null, this$0.handler);
                        aFHttpResponse = Unit.INSTANCE;
                        break block12;
                    }
                    ExtensionsKt.executeOnCompleteOnMainThread($urlResolverListener, it, this$0.handler);
                    aFHttpResponse = Unit.INSTANCE;
                }
                object = aFHttpResponse;
                if (aFHttpResponse != null) break block13;
            }
            ExtensionsKt.executeOnCompleteOnMainThread($urlResolverListener, null, this$0.handler);
            object = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ AFHttpResponse access$resolveInternal(URLResolver $this, String uri, Function1 logic) {
        return $this.resolveInternal(uri, (Function1<? super HttpURLConnection, String>)logic);
    }

    public static final /* synthetic */ void access$afDebugLog(URLResolver $this, String msg) {
        $this.afDebugLog(msg);
    }
}

