/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.resolver;

import android.util.Log;
import com.appsflyer.resolver.AFHttpResponse;
import com.appsflyer.resolver.URLResolverListener;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\f\u0010\u0015\u001a\u00020\u0003*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/appsflyer/resolver/URLResolver;", "", "debug", "", "(Z)V", "afDebugLog", "", "msg", "", "afErrorLog", "e", "", "resolve", "url", "maxRedirections", "", "urlResolverListener", "Lcom/appsflyer/resolver/URLResolverListener;", "resolveInternal", "Lcom/appsflyer/resolver/AFHttpResponse;", "uri", "isValidURL", "Companion", "AppsFlyerURLResolverLib_release"})
public final class URLResolver {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean debug;
    @Deprecated
    @NotNull
    public static final String TAG = "AppsFlyer_Resolver";

    public URLResolver(boolean debug) {
        this.debug = debug;
        CookieHandler.setDefault(new CookieManager());
    }

    public /* synthetic */ URLResolver(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final void resolve(@Nullable String url, int maxRedirections, @NotNull URLResolverListener urlResolverListener) {
        Intrinsics.checkNotNullParameter((Object)urlResolverListener, (String)"urlResolverListener");
        new Thread(() -> URLResolver.resolve$lambda-2(url, urlResolverListener, this, maxRedirections)).start();
    }

    public static /* synthetic */ void resolve$default(URLResolver uRLResolver, String string, int n, URLResolverListener uRLResolverListener, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        uRLResolver.resolve(string, n, uRLResolverListener);
    }

    private final AFHttpResponse resolveInternal(String uri) {
        AFHttpResponse res = new AFHttpResponse();
        try {
            URLConnection uRLConnection = new URL(uri).openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            uRLConnection = (HttpURLConnection)uRLConnection;
            boolean bl = false;
            boolean bl2 = false;
            URLConnection $this$resolveInternal_u24lambda_u2d3 = uRLConnection;
            boolean bl3 = false;
            ((HttpURLConnection)$this$resolveInternal_u24lambda_u2d3).setInstanceFollowRedirects(false);
            $this$resolveInternal_u24lambda_u2d3.setReadTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            $this$resolveInternal_u24lambda_u2d3.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            int responseCode = ((HttpURLConnection)$this$resolveInternal_u24lambda_u2d3).getResponseCode();
            res.setStatus(responseCode);
            boolean bl4 = 300 <= responseCode ? responseCode <= 308 : false;
            if (bl4) {
                res.setRedirected($this$resolveInternal_u24lambda_u2d3.getHeaderField("Location"));
                this.afDebugLog(Intrinsics.stringPlus((String)"redirecting to ", (Object)res.getRedirected()));
            }
            ((HttpURLConnection)$this$resolveInternal_u24lambda_u2d3).disconnect();
        }
        catch (Throwable e) {
            res.setError(e.getLocalizedMessage());
            this.afErrorLog(e.getMessage(), e);
        }
        return res;
    }

    private final void afDebugLog(String msg) {
        if (this.debug) {
            Log.d((String)TAG, (String)msg);
        }
    }

    private final void afErrorLog(String msg, Throwable e) {
        if (msg != null) {
            Log.e((String)TAG, (String)msg);
        }
        e.printStackTrace();
    }

    private final boolean isValidURL(String $this$isValidURL) {
        Regex regex = new Regex("^(http|https)://(\\w+:{0,1}\\w*@)?(\\S+)(:[0-9]+)?(/|/([\\w#!:.?+=&%@\\-/]))?");
        return regex.matches((CharSequence)$this$isValidURL);
    }

    private static final void resolve$lambda-2(String $url, URLResolverListener $urlResolverListener, URLResolver this$0, int $maxRedirections) {
        Intrinsics.checkNotNullParameter((Object)$urlResolverListener, (String)"$urlResolverListener");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($url == null) {
            $urlResolverListener.onComplete(null);
            return;
        }
        this$0.afDebugLog(Intrinsics.stringPlus((String)"resolving ", (Object)$url));
        if (this$0.isValidURL($url)) {
            AFHttpResponse aFHttpResponse;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            boolean bl = false;
            ArrayList<String> $this$resolve_u24lambda_u2d2_u24lambda_u2d0 = arrayList;
            boolean bl2 = false;
            $this$resolve_u24lambda_u2d2_u24lambda_u2d0.add($url);
            ArrayList<String> redirects = arrayList;
            AFHttpResponse res = null;
            n = 0;
            if (n < $maxRedirections) {
                do {
                    Boolean bl3;
                    int i = n++;
                    res = this$0.resolveInternal((String)CollectionsKt.last((List)redirects));
                    String string = res.getRedirected();
                    if (string == null) {
                        bl3 = null;
                    } else {
                        String string2 = string;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        String it = string2;
                        boolean bl6 = false;
                        bl3 = redirects.add(it);
                    }
                    Boolean bl7 = bl3;
                    if (bl7 == null) break;
                    bl7.booleanValue();
                } while (n < $maxRedirections);
            }
            if (((aFHttpResponse = res) == null ? null : aFHttpResponse.getError()) == null) {
                this$0.afDebugLog(Intrinsics.stringPlus((String)"found link: ", (Object)CollectionsKt.last((List)redirects)));
                $urlResolverListener.onComplete((String)CollectionsKt.last((List)redirects));
            } else {
                $urlResolverListener.onComplete(null);
            }
        } else {
            $urlResolverListener.onComplete($url);
        }
    }

    public URLResolver() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/appsflyer/resolver/URLResolver$Companion;", "", "()V", "TAG", "", "AppsFlyerURLResolverLib_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

