/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFc1qSDK;
import com.appsflyer.internal.AFd1iSDK;
import com.appsflyer.internal.AFe1mSDK;
import com.appsflyer.internal.AFe1pSDK;
import com.appsflyer.internal.AFe1uSDK;
import com.appsflyer.internal.AFe1wSDK;
import com.appsflyer.internal.AFf1rSDK;
import com.appsflyer.internal.AFg1oSDK;
import java.util.Map;
import org.json.JSONException;

public final class AFg1kSDK
extends AFe1mSDK<Void> {
    private final AFc1qSDK component1;
    @Nullable
    private final AFe1wSDK<String> component2;
    @Nullable
    private final Throwable component3;

    public AFg1kSDK(AFf1rSDK aFf1rSDK, AFc1qSDK aFc1qSDK) {
        super(AFe1pSDK.copydefault, new AFe1pSDK[]{AFe1pSDK.AFAdRevenueData}, "GCD-CHECK");
        this.component3 = aFf1rSDK.component1();
        this.component2 = aFf1rSDK.areAllFieldsValid;
        this.component1 = aFc1qSDK;
    }

    @Override
    @NonNull
    public final AFe1uSDK getRevenue() throws Exception {
        Map<String, Object> map;
        int n = this.component1.getRevenue("appsFlyerCount", 0);
        AFLogger.afDebugLog("[GCD-A01] Loading conversion data. Counter: ".concat(String.valueOf(n)));
        long l = this.component1.getMonetizationNetwork("appsflyerConversionDataCacheExpiration", 0L);
        if (l != 0L && System.currentTimeMillis() - l > 5184000000L) {
            AFLogger.afDebugLog("[GCD-E02] Cached conversion data expired");
            this.component1.AFAdRevenueData("sixtyDayConversionData", true);
            this.component1.getRevenue("attributionId", null);
            this.component1.AFAdRevenueData("appsflyerConversionDataCacheExpiration", 0L);
        }
        if ((map = this.component2()) != null) {
            try {
                if (!map.containsKey("is_first_launch")) {
                    map.put("is_first_launch", Boolean.FALSE);
                }
                AFg1oSDK.getCurrencyIso4217Code(map);
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("[GCD] Error executing conversion data callback: " + exception.getLocalizedMessage(), exception);
            }
            return AFe1uSDK.getCurrencyIso4217Code;
        }
        try {
            if (this.component3 != null) {
                AFg1oSDK.getRevenue("Launch exception: " + this.component3.getMessage());
                return AFe1uSDK.getCurrencyIso4217Code;
            }
            if (this.component2 != null && !this.component2.isSuccessful()) {
                AFg1oSDK.getRevenue("Launch status code: " + this.component2.getStatusCode());
                return AFe1uSDK.getCurrencyIso4217Code;
            }
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("[GCD] Error executing conversion data callback: " + exception.getLocalizedMessage(), exception);
        }
        return AFe1uSDK.AFAdRevenueData;
    }

    @Override
    public final long AFAdRevenueData() {
        return 1000L;
    }

    @Override
    public final boolean getMonetizationNetwork() {
        return false;
    }

    @Nullable
    private Map<String, Object> component2() {
        String string = this.component1.getMonetizationNetwork("attributionId", null);
        if (string == null) {
            return null;
        }
        try {
            new AFd1iSDK();
            return AFd1iSDK.getMediationNetwork(string);
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLog("[GCD] Failed to parse GCD response: " + jSONException.getMessage(), jSONException);
            return null;
        }
    }
}

