/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFc1oSDK;
import com.appsflyer.internal.AFd1iSDK;
import com.appsflyer.internal.AFe1lSDK;
import com.appsflyer.internal.AFe1mSDK;
import com.appsflyer.internal.AFe1uSDK;
import com.appsflyer.internal.AFe1xSDK;
import com.appsflyer.internal.AFf1rSDK;
import com.appsflyer.internal.AFg1pSDK;
import java.util.Map;
import org.json.JSONException;

public final class AFg1iSDK
extends AFe1lSDK<Void> {
    private final AFc1oSDK component4;
    @Nullable
    private final AFe1xSDK<String> component2;
    @Nullable
    private final Throwable component3;

    public AFg1iSDK(AFf1rSDK aFf1rSDK, AFc1oSDK aFc1oSDK) {
        super(AFe1mSDK.hashCode, new AFe1mSDK[]{AFe1mSDK.getCurrencyIso4217Code}, "GCD-CHECK");
        this.component3 = aFf1rSDK.component1();
        this.component2 = aFf1rSDK.component3;
        this.component4 = aFc1oSDK;
    }

    @Override
    @NonNull
    public final AFe1uSDK getMediationNetwork() throws Exception {
        Map<String, Object> map;
        int n = this.component4.getMediationNetwork("appsFlyerCount", 0);
        AFLogger.afDebugLog("[GCD-A01] Loading conversion data. Counter: ".concat(String.valueOf(n)));
        long l = this.component4.getCurrencyIso4217Code("appsflyerConversionDataCacheExpiration", 0L);
        if (l != 0L && System.currentTimeMillis() - l > 5184000000L) {
            AFLogger.afDebugLog("[GCD-E02] Cached conversion data expired");
            this.component4.getCurrencyIso4217Code("sixtyDayConversionData", true);
            this.component4.AFAdRevenueData("attributionId", null);
            this.component4.getRevenue("appsflyerConversionDataCacheExpiration", 0L);
        }
        if ((map = this.areAllFieldsValid()) != null) {
            try {
                if (!map.containsKey("is_first_launch")) {
                    map.put("is_first_launch", Boolean.FALSE);
                }
                AFg1pSDK.getMonetizationNetwork(map);
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("[GCD] Error executing conversion data callback: " + exception.getLocalizedMessage(), exception);
            }
            return AFe1uSDK.getRevenue;
        }
        try {
            if (this.component3 != null) {
                AFg1pSDK.getRevenue("Launch exception: " + this.component3.getMessage());
                return AFe1uSDK.getRevenue;
            }
            if (this.component2 != null && !this.component2.isSuccessful()) {
                AFg1pSDK.getRevenue("Launch status code: " + this.component2.getStatusCode());
                return AFe1uSDK.getRevenue;
            }
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("[GCD] Error executing conversion data callback: " + exception.getLocalizedMessage(), exception);
        }
        return AFe1uSDK.getMediationNetwork;
    }

    @Override
    public final long getCurrencyIso4217Code() {
        return 1000L;
    }

    @Override
    public final boolean AFAdRevenueData() {
        return false;
    }

    @Nullable
    private Map<String, Object> areAllFieldsValid() {
        String string = this.component4.getMonetizationNetwork("attributionId", null);
        if (string == null) {
            return null;
        }
        try {
            new AFd1iSDK();
            return AFd1iSDK.getRevenue(string);
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLog("[GCD] Failed to parse GCD response: " + jSONException.getMessage(), jSONException);
            return null;
        }
    }
}

