/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFc1hSDK;
import com.appsflyer.internal.AFc1qSDK;
import com.appsflyer.internal.AFg1cSDK;
import com.appsflyer.internal.AFg1fSDK;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AFf1bSDK {
    @NotNull
    private final Map<String, Object> getMonetizationNetwork;
    @Nullable
    private final PackageManager getCurrencyIso4217Code;
    @NotNull
    private final String getMediationNetwork;

    public AFf1bSDK(@NotNull AFc1hSDK aFc1hSDK, @NotNull AFc1qSDK aFc1qSDK) {
        Intrinsics.checkNotNullParameter((Object)aFc1hSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFc1qSDK, (String)"");
        this.getMonetizationNetwork = new LinkedHashMap();
        Context context = aFc1hSDK.getRevenue;
        this.getCurrencyIso4217Code = context != null ? context.getPackageManager() : null;
        String string = aFc1qSDK.getCurrencyIso4217Code.getRevenue.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        this.getMediationNetwork = string;
    }

    @NotNull
    public final Map<String, Object> getRevenue() {
        if (this.getMonetizationNetwork.isEmpty()) {
            try {
                Object object = this.getCurrencyIso4217Code;
                if (object != null && (object = object.getInstallerPackageName(this.getMediationNetwork)) != null) {
                    Object object2 = object;
                    this.getMonetizationNetwork.put("installer_package", object2);
                }
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("Exception while getting the app's installer package. ", exception);
            }
            if (Build.VERSION.SDK_INT >= 30) {
                this.getMonetizationNetwork.put("install_source_info", this.getMonetizationNetwork());
            }
        }
        return this.getMonetizationNetwork;
    }

    @RequiresApi(value=30)
    private final Map<String, Object> getMonetizationNetwork() {
        Map map = new LinkedHashMap();
        try {
            String string = this.getMediationNetwork;
            PackageManager packageManager = this.getCurrencyIso4217Code;
            if (packageManager != null && (packageManager = packageManager.getInstallSourceInfo(string)) != null) {
                Object object = packageManager;
                Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"");
                string = object;
                object = new LinkedHashMap();
                String string2 = string.getInitiatingPackageName();
                String string3 = "initiating_package";
                Map map2 = object;
                if (string2 != null) {
                    map2.put(string3, string2);
                }
                string2 = string.getInstallingPackageName();
                string3 = "installing_package";
                map2 = object;
                if (string2 != null) {
                    map2.put(string3, string2);
                }
                string2 = string.getOriginatingPackageName();
                string3 = "originating_package";
                map2 = object;
                if (string2 != null) {
                    map2.put(string3, string2);
                }
                map = object;
            }
        }
        catch (Throwable throwable) {
            AFLogger aFLogger = AFLogger.INSTANCE;
            AFg1cSDK aFg1cSDK = AFg1cSDK.e;
            AFg1fSDK.e$default(aFLogger, aFg1cSDK, "Failed to get the app install source info", throwable, true, false, true, true, 16, null);
        }
        return map;
    }
}

