/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFj1iSDK;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import javax.security.auth.x500.X500Principal;

public class AFKeystoreWrapper {
    public final Object AFAdRevenueData = new Object();
    public KeyStore getMonetizationNetwork;
    private Context getRevenue;
    public String getCurrencyIso4217Code;
    public int getMediationNetwork;

    public AFKeystoreWrapper(Context context) {
        AFKeystoreWrapper aFKeystoreWrapper;
        this.getRevenue = aFKeystoreWrapper;
        this.getCurrencyIso4217Code = "";
        this.getMediationNetwork = 0;
        aFKeystoreWrapper = this;
        AFLogger.afInfoLog("Initialising KeyStore..");
        try {
            aFKeystoreWrapper.getMonetizationNetwork = KeyStore.getInstance("AndroidKeyStore");
            aFKeystoreWrapper.getMonetizationNetwork.load(null);
            return;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            AFLogger.afErrorLog("Couldn't load keystore instance of type: AndroidKeyStore", exception);
            return;
        }
    }

    public final boolean getMediationNetwork() {
        boolean bl = false;
        Object object = this.AFAdRevenueData;
        synchronized (object) {
            if (this.getMonetizationNetwork != null) {
                try {
                    String[] stringArray = this.getMonetizationNetwork.aliases();
                    while (stringArray.hasMoreElements()) {
                        String[] stringArray2 = stringArray.nextElement();
                        if (stringArray2 == null || !AFKeystoreWrapper.getMediationNetwork((String)stringArray2)) continue;
                        stringArray = stringArray2.split(",");
                        if (stringArray.length == 3) {
                            AFLogger.afInfoLog("Found a matching AF key with alias:\n".concat(String.valueOf(stringArray2)));
                            bl = true;
                            stringArray2 = stringArray[1].trim().split("=");
                            stringArray = stringArray[2].trim().split("=");
                            if (stringArray2.length == 2 && stringArray.length == 2) {
                                this.getCurrencyIso4217Code = stringArray2[1].trim();
                                this.getMediationNetwork = Integer.parseInt(stringArray[1].trim());
                            }
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    AFLogger.afErrorLog("Couldn't list KeyStore Aliases: " + throwable.getClass().getName(), throwable);
                }
            }
        }
        return bl;
    }

    public final void AFAdRevenueData(String object) {
        AFLogger.afInfoLog("Creating a new key with alias: ".concat(String.valueOf(object)));
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(1, 5);
            KeyGenParameterSpec keyGenParameterSpec = null;
            Object object2 = this.AFAdRevenueData;
            synchronized (object2) {
                if (!this.getMonetizationNetwork.containsAlias((String)object)) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        keyGenParameterSpec = new KeyGenParameterSpec.Builder((String)object, 3).setCertificateSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setCertificateSerialNumber(BigInteger.ONE).setCertificateNotBefore(calendar.getTime()).setCertificateNotAfter(calendar2.getTime()).build();
                    } else if (!AFj1iSDK.getCurrencyIso4217Code()) {
                        keyGenParameterSpec = new KeyPairGeneratorSpec.Builder(this.getRevenue).setAlias((String)object).setSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setSerialNumber(BigInteger.ONE).setStartDate(calendar.getTime()).setEndDate(calendar2.getTime()).build();
                    }
                    object = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                    ((KeyPairGenerator)object).initialize((AlgorithmParameterSpec)keyGenParameterSpec);
                    ((KeyPairGeneratorSpi)object).generateKeyPair();
                } else {
                    AFLogger.afInfoLog("Alias already exists: ".concat(String.valueOf(object)));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("Exception " + throwable.getMessage() + " occurred", throwable);
            return;
        }
    }

    private static boolean getMediationNetwork(String string) {
        return string.startsWith("com.appsflyer");
    }

    public final String getRevenue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("com.appsflyer,");
        Object object = this.AFAdRevenueData;
        synchronized (object) {
            stringBuilder.append("KSAppsFlyerId=").append(this.getCurrencyIso4217Code).append(",");
            stringBuilder.append("KSAppsFlyerRICounter=").append(this.getMediationNetwork);
        }
        return ((Object)stringBuilder).toString();
    }

    public final String AFAdRevenueData() {
        Object object = this.AFAdRevenueData;
        synchronized (object) {
            return this.getCurrencyIso4217Code;
        }
    }

    public final int getMonetizationNetwork() {
        Object object = this.AFAdRevenueData;
        synchronized (object) {
            return this.getMediationNetwork;
        }
    }
}

