/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFc1kSDK;
import com.appsflyer.internal.AFh1zSDK;
import com.appsflyer.internal.AFi1fSDK;
import com.appsflyer.internal.AFj1nSDK;
import com.appsflyer.internal.AFj1ySDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1iSDK
extends AFi1fSDK {
    public final Map<String, Object> getMediationNetwork = new HashMap<String, Object>();
    @NonNull
    final ExecutorService getCurrencyIso4217Code;

    public AFi1iSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFc1kSDK aFc1kSDK) {
        super("store", "google", aFc1kSDK, runnable);
        this.getCurrencyIso4217Code = executorService;
    }

    private boolean getMonetizationNetwork(@NonNull Context context) {
        if (!this.getRevenue()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFj1nSDK.getMediationNetwork(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.INSTANCE.d(AFh1zSDK.toString, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.INSTANCE.v(AFh1zSDK.toString, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFh1zSDK.toString, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.INSTANCE.d(AFh1zSDK.toString, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void getRevenue(Context context) {
        if (!this.getMonetizationNetwork(context)) {
            return;
        }
        AFi1iSDK aFi1iSDK = this;
        this.areAllFieldsValid = System.currentTimeMillis();
        aFi1iSDK.component1 = AFj1ySDK.AFa1vSDK.getMediationNetwork;
        aFi1iSDK.addObserver(new Observer(aFi1iSDK){
            private /* synthetic */ AFj1ySDK getCurrencyIso4217Code;
            {
                this.getCurrencyIso4217Code = aFj1ySDK;
            }

            public final void update(Observable o, Object arg) {
                this.getCurrencyIso4217Code.getMonetizationNetwork.run();
            }
        });
        try {
            aFi1iSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.INSTANCE.d(AFh1zSDK.toString, "Connecting to Install Referrer Library...");
            aFi1iSDK.startConnection(new InstallReferrerStateListener(){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int responseCode) {
                    AFi1iSDK.this.getCurrencyIso4217Code.execute(() -> AFi1iSDK.this.getMonetizationNetwork(this.val$referrerClient, this.val$context, responseCode));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.INSTANCE.d(AFh1zSDK.toString, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFh1zSDK.toString, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void getMonetizationNetwork(InstallReferrerClient installReferrerClient, Context context, int n) {
        this.getMediationNetwork.put("code", String.valueOf(n));
        String string = "com.android.vending";
        this.AFAdRevenueData.put("api_ver", AFj1nSDK.AFAdRevenueData(context, string));
        this.AFAdRevenueData.put("api_ver_name", AFj1nSDK.getCurrencyIso4217Code(context, string));
        switch (n) {
            case 0: {
                this.AFAdRevenueData.put("response", "OK");
                try {
                    AFLogger.INSTANCE.d(AFh1zSDK.toString, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            this.getMediationNetwork.put("val", object);
                            this.AFAdRevenueData.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        this.getMediationNetwork.put("clk", Long.toString(l));
                        this.AFAdRevenueData.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        this.getMediationNetwork.put("install", Long.toString(l2));
                        this.AFAdRevenueData.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            this.getMediationNetwork.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.INSTANCE.e(AFh1zSDK.toString, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.AFAdRevenueData.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.INSTANCE.w(AFh1zSDK.toString, "ReferrerClient: InstallReferrer is not ready");
                    this.getMediationNetwork.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.INSTANCE.w(AFh1zSDK.toString, "Failed to get install referrer: " + throwable.getMessage());
                    this.getMediationNetwork.put("err", throwable.getMessage());
                    AFLogger.INSTANCE.e(AFh1zSDK.toString, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                AFLogger.INSTANCE.w(AFh1zSDK.toString, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.AFAdRevenueData.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.AFAdRevenueData.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.INSTANCE.w(AFh1zSDK.toString, "InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.INSTANCE.w(AFh1zSDK.toString, "InstallReferrer DEVELOPER_ERROR");
                this.AFAdRevenueData.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.INSTANCE.w(AFh1zSDK.toString, "InstallReferrer SERVICE_DISCONNECTED");
                this.AFAdRevenueData.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.INSTANCE.w(AFh1zSDK.toString, "responseCode not found.");
            }
        }
        AFLogger.INSTANCE.d(AFh1zSDK.toString, "Install Referrer collected locally");
        this.getMonetizationNetwork();
    }
}

