/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1fSDK;
import com.appsflyer.internal.AFh1iSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1zSDK {
    private final boolean getCurrencyIso4217Code;
    @NonNull
    public final String AFAdRevenueData;
    @NonNull
    public final String getMediationNetwork;
    @NonNull
    public final AFh1fSDK getMonetizationNetwork;
    @Nullable
    public final AFh1iSDK getRevenue;

    public AFi1zSDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.AFAdRevenueData = jSONObject.getString("ver");
            this.getCurrencyIso4217Code = jSONObject.optBoolean("test_mode");
            this.getMediationNetwork = object;
            this.getMonetizationNetwork = this.AFAdRevenueData.startsWith("default") ? AFh1fSDK.getMonetizationNetwork : AFh1fSDK.getCurrencyIso4217Code;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFh1iSDK(jSONObject);
            }
            this.getRevenue = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFi1zSDK aFi1zSDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFi1zSDK = aFi1zSDK;
        if (this.getCurrencyIso4217Code != aFi1zSDK.getCurrencyIso4217Code) {
            return false;
        }
        if (!this.AFAdRevenueData.equals(aFi1zSDK.AFAdRevenueData)) {
            return false;
        }
        return this.getMediationNetwork.equals(aFi1zSDK.getMediationNetwork);
    }

    public final int hashCode() {
        int n = this.getCurrencyIso4217Code ? 1 : 0;
        n = n * 31 + this.AFAdRevenueData.hashCode();
        n = n * 31 + this.getMediationNetwork.hashCode();
        if (this.getRevenue != null) {
            n = n * 31 + ((Object)this.getRevenue).hashCode();
        }
        return n;
    }
}

