/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFi1xSDK;
import com.appsflyer.internal.AFi1ySDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1qSDK {
    private final boolean getMonetizationNetwork;
    @NonNull
    public final String getCurrencyIso4217Code;
    @NonNull
    public final String getRevenue;
    @NonNull
    public final AFi1ySDK AFAdRevenueData;
    @Nullable
    public final AFi1xSDK getMediationNetwork;

    public AFi1qSDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.getCurrencyIso4217Code = jSONObject.getString("ver");
            this.getMonetizationNetwork = jSONObject.optBoolean("test_mode");
            this.getRevenue = object;
            this.AFAdRevenueData = this.getCurrencyIso4217Code.startsWith("default") ? AFi1ySDK.getMonetizationNetwork : AFi1ySDK.getRevenue;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFi1xSDK(jSONObject);
            }
            this.getMediationNetwork = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFi1qSDK aFi1qSDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFi1qSDK = aFi1qSDK;
        if (this.getMonetizationNetwork != aFi1qSDK.getMonetizationNetwork) {
            return false;
        }
        if (!this.getCurrencyIso4217Code.equals(aFi1qSDK.getCurrencyIso4217Code)) {
            return false;
        }
        return this.getRevenue.equals(aFi1qSDK.getRevenue);
    }

    public final int hashCode() {
        int n = this.getMonetizationNetwork ? 1 : 0;
        n = n * 31 + this.getCurrencyIso4217Code.hashCode();
        n = n * 31 + this.getRevenue.hashCode();
        if (this.getMediationNetwork != null) {
            n = n * 31 + ((Object)this.getMediationNetwork).hashCode();
        }
        return n;
    }
}

