/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1qSDK;
import com.appsflyer.internal.AFd1qSDK;
import com.appsflyer.internal.AFh1vSDK;
import com.appsflyer.internal.AFi1cSDK;
import com.appsflyer.internal.AFj1sSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1eSDK
extends AFi1cSDK {
    public final Map<String, Object> getRevenue = new HashMap<String, Object>();
    @NonNull
    final ExecutorService getCurrencyIso4217Code;

    public AFi1eSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFd1qSDK aFd1qSDK) {
        super("store", "google", aFd1qSDK, runnable);
        this.getCurrencyIso4217Code = executorService;
    }

    private boolean AFAdRevenueData(@NonNull Context context) {
        if (!this.getMonetizationNetwork()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFb1qSDK.getRevenue(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.INSTANCE.d(AFh1vSDK.hashCode, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.INSTANCE.v(AFh1vSDK.hashCode, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFh1vSDK.hashCode, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.INSTANCE.d(AFh1vSDK.hashCode, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void getMediationNetwork(Context context) {
        if (!this.AFAdRevenueData(context)) {
            return;
        }
        AFi1eSDK aFi1eSDK = this;
        this.component1 = System.currentTimeMillis();
        aFi1eSDK.component2 = AFj1sSDK.AFa1zSDK.AFAdRevenueData;
        aFi1eSDK.addObserver(new Observer(aFi1eSDK){
            private /* synthetic */ AFj1sSDK getMediationNetwork;
            {
                this.getMediationNetwork = aFj1sSDK;
            }

            public final void update(Observable o, Object arg) {
                this.getMediationNetwork.AFAdRevenueData.run();
            }
        });
        try {
            aFi1eSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.INSTANCE.d(AFh1vSDK.hashCode, "Connecting to Install Referrer Library...");
            aFi1eSDK.startConnection(new InstallReferrerStateListener(){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int responseCode) {
                    AFi1eSDK.this.getCurrencyIso4217Code.execute(() -> AFi1eSDK.this.AFAdRevenueData(this.val$referrerClient, this.val$context, responseCode));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.INSTANCE.d(AFh1vSDK.hashCode, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFh1vSDK.hashCode, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void AFAdRevenueData(InstallReferrerClient installReferrerClient, Context context, int n) {
        this.getRevenue.put("code", String.valueOf(n));
        String string = "com.android.vending";
        this.getMediationNetwork.put("api_ver", AFb1qSDK.AFAdRevenueData(context, string));
        this.getMediationNetwork.put("api_ver_name", AFb1qSDK.getMediationNetwork(context, string));
        switch (n) {
            case 0: {
                this.getMediationNetwork.put("response", "OK");
                try {
                    AFLogger.INSTANCE.d(AFh1vSDK.hashCode, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            this.getRevenue.put("val", object);
                            this.getMediationNetwork.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        this.getRevenue.put("clk", Long.toString(l));
                        this.getMediationNetwork.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        this.getRevenue.put("install", Long.toString(l2));
                        this.getMediationNetwork.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            this.getRevenue.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.INSTANCE.e(AFh1vSDK.hashCode, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.getMediationNetwork.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.INSTANCE.w(AFh1vSDK.hashCode, "ReferrerClient: InstallReferrer is not ready");
                    this.getRevenue.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.INSTANCE.w(AFh1vSDK.hashCode, "Failed to get install referrer: " + throwable.getMessage());
                    this.getRevenue.put("err", throwable.getMessage());
                    AFLogger.INSTANCE.e(AFh1vSDK.hashCode, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                AFLogger.INSTANCE.w(AFh1vSDK.hashCode, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.getMediationNetwork.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.getMediationNetwork.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.INSTANCE.w(AFh1vSDK.hashCode, "InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.INSTANCE.w(AFh1vSDK.hashCode, "InstallReferrer DEVELOPER_ERROR");
                this.getMediationNetwork.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.INSTANCE.w(AFh1vSDK.hashCode, "InstallReferrer SERVICE_DISCONNECTED");
                this.getMediationNetwork.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.INSTANCE.w(AFh1vSDK.hashCode, "responseCode not found.");
            }
        }
        AFLogger.INSTANCE.d(AFh1vSDK.hashCode, "Install Referrer collected locally");
        this.getRevenue();
    }
}

