/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import com.appsflyer.internal.AFh1dSDK;
import com.appsflyer.internal.AFi1uSDK;
import com.appsflyer.internal.AFi1xSDK;
import java.util.ArrayList;
import java.util.List;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFh1cSDK {
    @Nullable
    public final AFh1dSDK getMediationNetwork;
    @Nullable
    public final AFi1xSDK getMonetizationNetwork;
    @Nullable
    public AFi1uSDK getCurrencyIso4217Code;

    public AFh1cSDK(@NotNull JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"");
        this.getCurrencyIso4217Code = AFh1cSDK.AFAdRevenueData(jSONObject);
        this.getMediationNetwork = AFh1cSDK.getRevenue(jSONObject);
        this.getMonetizationNetwork = AFh1cSDK.getMonetizationNetwork(jSONObject);
    }

    private static AFi1xSDK getMonetizationNetwork(JSONObject object) {
        try {
            AFi1xSDK aFi1xSDK;
            JSONObject jSONObject = AFh1cSDK.getRevenue((JSONObject)object, "meta_data");
            if (jSONObject != null) {
                double d = jSONObject.optDouble("send_rate", 1.0);
                aFi1xSDK = new AFi1xSDK(d);
            } else {
                aFi1xSDK = null;
            }
            object = Result.constructor-impl(aFi1xSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFi1xSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFh1dSDK getRevenue(JSONObject object) {
        try {
            AFh1dSDK aFh1dSDK;
            JSONObject jSONObject = AFh1cSDK.getRevenue((JSONObject)object, "exc_mngr");
            if (jSONObject != null) {
                object = jSONObject;
                String string = jSONObject.getString("sdk_ver");
                int n = object.optInt("min", -1);
                int n2 = object.optInt("expire", -1);
                long l = object.optLong("ttl", -1L);
                aFh1dSDK = new AFh1dSDK(string, n, n2, l);
            } else {
                aFh1dSDK = null;
            }
            object = Result.constructor-impl(aFh1dSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFh1dSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFi1uSDK AFAdRevenueData(JSONObject object) {
        try {
            AFi1uSDK aFi1uSDK;
            JSONObject jSONObject = AFh1cSDK.getRevenue(object, "r_debugger");
            if (jSONObject != null) {
                List list;
                object = jSONObject;
                long l = jSONObject.getLong("ttl");
                int n = object.getInt("counter");
                String string = object.optString("app_ver", "");
                String string2 = object.optString("sdk_ver", "");
                float f = (float)object.optDouble("ratio", 1.0);
                if ((object = object.optJSONArray("tags")) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                    List list2 = new ArrayList();
                    int n2 = object.length();
                    for (int i = 0; i < n2; ++i) {
                        String string3 = object.getString(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                        list2.add(string3);
                    }
                    list = list2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                object = list;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                aFi1uSDK = new AFi1uSDK(l, f, (List<String>)object, n, string, string2);
            } else {
                aFi1uSDK = null;
            }
            object = Result.constructor-impl(aFi1uSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFi1uSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static JSONObject getRevenue(JSONObject jSONObject, String string) throws JSONException, NullPointerException {
        if (jSONObject.has(string)) {
            if ((jSONObject = jSONObject.getJSONArray(string).optJSONObject(0).optJSONObject("data")) != null) {
                return jSONObject.optJSONObject("v1");
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(@Nullable Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"");
        AFh1cSDK cfr_ignored_0 = (AFh1cSDK)other;
        if (!Intrinsics.areEqual((Object)this.getMediationNetwork, (Object)((AFh1cSDK)other).getMediationNetwork)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getMonetizationNetwork, (Object)((AFh1cSDK)other).getMonetizationNetwork)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getCurrencyIso4217Code, (Object)((AFh1cSDK)var1_1).getCurrencyIso4217Code);
    }

    public final int hashCode() {
        AFh1dSDK aFh1dSDK = this.getMediationNetwork;
        int n = aFh1dSDK != null ? ((Object)aFh1dSDK).hashCode() : 0;
        AFi1xSDK aFi1xSDK = this.getMonetizationNetwork;
        n = n * 31 + (aFi1xSDK != null ? aFi1xSDK.hashCode() : 0);
        AFi1uSDK aFi1uSDK = this.getCurrencyIso4217Code;
        return n * 31 + (aFi1uSDK != null ? ((Object)aFi1uSDK).hashCode() : 0);
    }
}

