/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import com.appsflyer.internal.AFh1bSDK;
import com.appsflyer.internal.AFh1cSDK;
import com.appsflyer.internal.AFi1vSDK;
import java.util.ArrayList;
import java.util.List;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFh1dSDK {
    @Nullable
    public final AFh1bSDK getCurrencyIso4217Code;
    @Nullable
    public final AFh1cSDK getMonetizationNetwork;
    @Nullable
    public AFi1vSDK getMediationNetwork;

    public AFh1dSDK(@NotNull JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"");
        this.getMediationNetwork = AFh1dSDK.AFAdRevenueData(jSONObject);
        this.getCurrencyIso4217Code = AFh1dSDK.getRevenue(jSONObject);
        this.getMonetizationNetwork = AFh1dSDK.getMediationNetwork(jSONObject);
    }

    private static AFh1cSDK getMediationNetwork(JSONObject object) {
        try {
            AFh1cSDK aFh1cSDK;
            JSONObject jSONObject = AFh1dSDK.getMediationNetwork((JSONObject)object, "meta_data");
            if (jSONObject != null) {
                double d = jSONObject.optDouble("send_rate", 1.0);
                aFh1cSDK = new AFh1cSDK(d);
            } else {
                aFh1cSDK = null;
            }
            object = Result.constructor-impl(aFh1cSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFh1cSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFh1bSDK getRevenue(JSONObject object) {
        try {
            AFh1bSDK aFh1bSDK;
            JSONObject jSONObject = AFh1dSDK.getMediationNetwork((JSONObject)object, "exc_mngr");
            if (jSONObject != null) {
                object = jSONObject;
                String string = jSONObject.getString("sdk_ver");
                int n = object.optInt("min", -1);
                int n2 = object.optInt("expire", -1);
                long l = object.optLong("ttl", -1L);
                aFh1bSDK = new AFh1bSDK(string, n, n2, l);
            } else {
                aFh1bSDK = null;
            }
            object = Result.constructor-impl(aFh1bSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFh1bSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFi1vSDK AFAdRevenueData(JSONObject object) {
        try {
            AFi1vSDK aFi1vSDK;
            JSONObject jSONObject = AFh1dSDK.getMediationNetwork(object, "r_debugger");
            if (jSONObject != null) {
                List list;
                object = jSONObject;
                long l = jSONObject.getLong("ttl");
                int n = object.getInt("counter");
                String string = object.optString("app_ver", "");
                String string2 = object.optString("sdk_ver", "");
                float f = (float)object.optDouble("ratio", 1.0);
                if ((object = object.optJSONArray("tags")) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                    List list2 = new ArrayList();
                    int n2 = object.length();
                    for (int i = 0; i < n2; ++i) {
                        String string3 = object.getString(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                        list2.add(string3);
                    }
                    list = list2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                object = list;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                aFi1vSDK = new AFi1vSDK(l, f, (List<String>)object, n, string, string2);
            } else {
                aFi1vSDK = null;
            }
            object = Result.constructor-impl(aFi1vSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFi1vSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static JSONObject getMediationNetwork(JSONObject jSONObject, String string) throws JSONException, NullPointerException {
        if (jSONObject.has(string)) {
            if ((jSONObject = jSONObject.getJSONArray(string).optJSONObject(0).optJSONObject("data")) != null) {
                return jSONObject.optJSONObject("v1");
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(@Nullable Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"");
        AFh1dSDK cfr_ignored_0 = (AFh1dSDK)other;
        if (!Intrinsics.areEqual((Object)this.getCurrencyIso4217Code, (Object)((AFh1dSDK)other).getCurrencyIso4217Code)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getMonetizationNetwork, (Object)((AFh1dSDK)other).getMonetizationNetwork)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getMediationNetwork, (Object)((AFh1dSDK)var1_1).getMediationNetwork);
    }

    public final int hashCode() {
        AFh1bSDK aFh1bSDK = this.getCurrencyIso4217Code;
        int n = aFh1bSDK != null ? ((Object)aFh1bSDK).hashCode() : 0;
        AFh1cSDK aFh1cSDK = this.getMonetizationNetwork;
        n = n * 31 + (aFh1cSDK != null ? aFh1cSDK.hashCode() : 0);
        AFi1vSDK aFi1vSDK = this.getMediationNetwork;
        return n * 31 + (aFi1vSDK != null ? ((Object)aFi1vSDK).hashCode() : 0);
    }
}

