/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import com.appsflyer.internal.AFh1cSDK;
import com.appsflyer.internal.AFh1fSDK;
import com.appsflyer.internal.AFi1zSDK;
import java.util.ArrayList;
import java.util.List;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFh1bSDK {
    @Nullable
    public final AFh1fSDK getCurrencyIso4217Code;
    @Nullable
    public final AFh1cSDK getMonetizationNetwork;
    @Nullable
    public AFi1zSDK getMediationNetwork;

    public AFh1bSDK(@NotNull JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"");
        this.getMediationNetwork = AFh1bSDK.AFAdRevenueData(jSONObject);
        this.getCurrencyIso4217Code = AFh1bSDK.getRevenue(jSONObject);
        this.getMonetizationNetwork = AFh1bSDK.getMediationNetwork(jSONObject);
    }

    private static AFh1cSDK getMediationNetwork(JSONObject object) {
        try {
            AFh1cSDK aFh1cSDK;
            JSONObject jSONObject = AFh1bSDK.getMediationNetwork((JSONObject)object, "meta_data");
            if (jSONObject != null) {
                double d = jSONObject.optDouble("send_rate", 1.0);
                aFh1cSDK = new AFh1cSDK(d);
            } else {
                aFh1cSDK = null;
            }
            object = Result.constructor-impl(aFh1cSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFh1cSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFh1fSDK getRevenue(JSONObject object) {
        try {
            AFh1fSDK aFh1fSDK;
            JSONObject jSONObject = AFh1bSDK.getMediationNetwork((JSONObject)object, "exc_mngr");
            if (jSONObject != null) {
                object = jSONObject;
                String string = jSONObject.getString("sdk_ver");
                int n = object.optInt("min", -1);
                int n2 = object.optInt("expire", -1);
                long l = object.optLong("ttl", -1L);
                aFh1fSDK = new AFh1fSDK(string, n, n2, l);
            } else {
                aFh1fSDK = null;
            }
            object = Result.constructor-impl(aFh1fSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFh1fSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFi1zSDK AFAdRevenueData(JSONObject object) {
        try {
            AFi1zSDK aFi1zSDK;
            JSONObject jSONObject = AFh1bSDK.getMediationNetwork(object, "r_debugger");
            if (jSONObject != null) {
                List list;
                object = jSONObject;
                long l = jSONObject.getLong("ttl");
                int n = object.getInt("counter");
                String string = object.optString("app_ver", "");
                String string2 = object.optString("sdk_ver", "");
                float f = (float)object.optDouble("ratio", 1.0);
                if ((object = object.optJSONArray("tags")) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                    List list2 = new ArrayList();
                    int n2 = object.length();
                    for (int i = 0; i < n2; ++i) {
                        String string3 = object.getString(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                        list2.add(string3);
                    }
                    list = list2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                object = list;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                aFi1zSDK = new AFi1zSDK(l, f, (List<String>)object, n, string, string2);
            } else {
                aFi1zSDK = null;
            }
            object = Result.constructor-impl(aFi1zSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFi1zSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static JSONObject getMediationNetwork(JSONObject jSONObject, String string) throws JSONException, NullPointerException {
        if (jSONObject.has(string)) {
            if ((jSONObject = jSONObject.getJSONArray(string).optJSONObject(0).optJSONObject("data")) != null) {
                return jSONObject.optJSONObject("v1");
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(@Nullable Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.appsflyer.internal.model.rc.Features");
        }
        AFh1bSDK cfr_ignored_0 = (AFh1bSDK)object2;
        if (!Intrinsics.areEqual((Object)this.getCurrencyIso4217Code, (Object)((AFh1bSDK)other).getCurrencyIso4217Code)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getMonetizationNetwork, (Object)((AFh1bSDK)other).getMonetizationNetwork)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getMediationNetwork, (Object)((AFh1bSDK)var1_1).getMediationNetwork);
    }

    public final int hashCode() {
        AFh1fSDK aFh1fSDK = this.getCurrencyIso4217Code;
        int n = aFh1fSDK != null ? ((Object)aFh1fSDK).hashCode() : 0;
        AFh1cSDK aFh1cSDK = this.getMonetizationNetwork;
        n = n * 31 + (aFh1cSDK != null ? aFh1cSDK.hashCode() : 0);
        AFi1zSDK aFi1zSDK = this.getMediationNetwork;
        return n * 31 + (aFi1zSDK != null ? ((Object)aFi1zSDK).hashCode() : 0);
    }
}

