/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1vSDK;
import com.appsflyer.internal.AFd1sSDK;
import com.appsflyer.internal.AFg1bSDK;
import com.appsflyer.internal.AFi1bSDK;
import com.appsflyer.internal.AFi1oSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1lSDK
extends AFi1oSDK {
    public final Map<String, Object> values = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFKeystoreWrapper;

    public AFi1lSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFd1sSDK aFd1sSDK) {
        super("store", "google", aFd1sSDK, runnable);
        this.AFKeystoreWrapper = executorService;
    }

    private boolean AFKeystoreWrapper(@NonNull Context context) {
        if (!this.AFKeystoreWrapper()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFb1vSDK.AFInAppEventType(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.INSTANCE.d(AFg1bSDK.unregisterClient, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.INSTANCE.v(AFg1bSDK.unregisterClient, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.INSTANCE.e(AFg1bSDK.unregisterClient, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.INSTANCE.d(AFg1bSDK.unregisterClient, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void values(Context context) {
        if (!this.AFKeystoreWrapper(context)) {
            return;
        }
        AFi1lSDK aFi1lSDK = this;
        this.AFLogger = System.currentTimeMillis();
        aFi1lSDK.registerClient = AFi1bSDK.AFa1uSDK.values;
        aFi1lSDK.addObserver(new Observer(aFi1lSDK){
            private /* synthetic */ AFi1bSDK values;
            {
                this.values = aFi1bSDK;
            }

            public final void update(Observable o, Object arg) {
                this.values.AFInAppEventParameterName.run();
            }
        });
        try {
            aFi1lSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.INSTANCE.d(AFg1bSDK.unregisterClient, "Connecting to Install Referrer Library...");
            aFi1lSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFi1lSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int responseCode) {
                    AFi1lSDK.this.AFKeystoreWrapper.execute(() -> AFi1lSDK.this.AFInAppEventParameterName(this.val$referrerClient, this.val$context, responseCode));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.INSTANCE.d(AFg1bSDK.unregisterClient, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.INSTANCE.e(AFg1bSDK.unregisterClient, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void AFInAppEventParameterName(InstallReferrerClient installReferrerClient, Context context, int n) {
        this.values.put("code", String.valueOf(n));
        String string = "com.android.vending";
        this.valueOf.put("api_ver", AFb1vSDK.AFKeystoreWrapper(context, string));
        this.valueOf.put("api_ver_name", AFb1vSDK.values(context, string));
        switch (n) {
            case 0: {
                this.valueOf.put("response", "OK");
                try {
                    com.appsflyer.AFLogger.INSTANCE.d(AFg1bSDK.unregisterClient, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            this.values.put("val", object);
                            this.valueOf.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        this.values.put("clk", Long.toString(l));
                        this.valueOf.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        this.values.put("install", Long.toString(l2));
                        this.valueOf.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            this.values.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.INSTANCE.e(AFg1bSDK.unregisterClient, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.valueOf.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    com.appsflyer.AFLogger.INSTANCE.w(AFg1bSDK.unregisterClient, "ReferrerClient: InstallReferrer is not ready");
                    this.values.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    com.appsflyer.AFLogger.INSTANCE.w(AFg1bSDK.unregisterClient, "Failed to get install referrer: " + throwable.getMessage());
                    this.values.put("err", throwable.getMessage());
                    com.appsflyer.AFLogger.INSTANCE.e(AFg1bSDK.unregisterClient, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1bSDK.unregisterClient, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.valueOf.put("response", "SERVICE_UNAVAILABLE");
                com.appsflyer.AFLogger.INSTANCE.w(AFg1bSDK.unregisterClient, "InstallReferrer not supported");
                break;
            }
            case 3: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1bSDK.unregisterClient, "InstallReferrer DEVELOPER_ERROR");
                this.valueOf.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1bSDK.unregisterClient, "InstallReferrer SERVICE_DISCONNECTED");
                this.valueOf.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1bSDK.unregisterClient, "responseCode not found.");
            }
        }
        com.appsflyer.AFLogger.INSTANCE.d(AFg1bSDK.unregisterClient, "Install Referrer collected locally");
        this.AFInAppEventType();
    }
}

