/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1gSDK;
import com.appsflyer.internal.AFh1hSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFh1aSDK {
    private final boolean values;
    @NonNull
    public final String valueOf;
    @NonNull
    public final String AFInAppEventType;
    @NonNull
    public final AFh1gSDK AFKeystoreWrapper;
    @Nullable
    public final AFh1hSDK AFInAppEventParameterName;

    public AFh1aSDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.valueOf = jSONObject.getString("ver");
            this.values = jSONObject.optBoolean("test_mode");
            this.AFInAppEventType = object;
            this.AFKeystoreWrapper = this.valueOf.startsWith("default") ? AFh1gSDK.AFInAppEventParameterName : AFh1gSDK.values;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFh1hSDK(jSONObject);
            }
            this.AFInAppEventParameterName = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFh1aSDK aFh1aSDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFh1aSDK = aFh1aSDK;
        if (this.values != aFh1aSDK.values) {
            return false;
        }
        if (!this.valueOf.equals(aFh1aSDK.valueOf)) {
            return false;
        }
        return this.AFInAppEventType.equals(aFh1aSDK.AFInAppEventType);
    }

    public final int hashCode() {
        int n = this.values ? 1 : 0;
        n = n * 31 + this.valueOf.hashCode();
        n = n * 31 + this.AFInAppEventType.hashCode();
        if (this.AFInAppEventParameterName != null) {
            n = n * 31 + ((Object)this.AFInAppEventParameterName).hashCode();
        }
        return n;
    }
}

