/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1gSDK;
import com.appsflyer.internal.AFh1iSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1zSDK {
    private final boolean valueOf;
    @NonNull
    public final String AFKeystoreWrapper;
    @NonNull
    public final String values;
    @NonNull
    public final AFh1iSDK AFInAppEventType;
    @Nullable
    public final AFh1gSDK AFInAppEventParameterName;

    public AFi1zSDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.AFKeystoreWrapper = jSONObject.getString("ver");
            this.valueOf = jSONObject.optBoolean("test_mode");
            this.values = object;
            this.AFInAppEventType = this.AFKeystoreWrapper.startsWith("default") ? AFh1iSDK.valueOf : AFh1iSDK.values;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFh1gSDK(jSONObject);
            }
            this.AFInAppEventParameterName = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFi1zSDK aFi1zSDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFi1zSDK = aFi1zSDK;
        if (this.valueOf != aFi1zSDK.valueOf) {
            return false;
        }
        if (!this.AFKeystoreWrapper.equals(aFi1zSDK.AFKeystoreWrapper)) {
            return false;
        }
        return this.values.equals(aFi1zSDK.values);
    }

    public final int hashCode() {
        int n = this.valueOf ? 1 : 0;
        n = n * 31 + this.AFKeystoreWrapper.hashCode();
        n = n * 31 + this.values.hashCode();
        if (this.AFInAppEventParameterName != null) {
            n = n * 31 + ((Object)this.AFInAppEventParameterName).hashCode();
        }
        return n;
    }
}

