/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1mSDK;
import com.appsflyer.internal.AFh1pSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFh1nSDK {
    private final boolean AFKeystoreWrapper;
    @NonNull
    public final String values;
    @NonNull
    public final String AFInAppEventParameterName;
    @NonNull
    public final AFh1pSDK valueOf;
    @Nullable
    public final AFh1mSDK AFInAppEventType;

    public AFh1nSDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.values = jSONObject.getString("ver");
            this.AFKeystoreWrapper = jSONObject.optBoolean("test_mode");
            this.AFInAppEventParameterName = object;
            this.valueOf = this.values.startsWith("default") ? AFh1pSDK.valueOf : AFh1pSDK.AFKeystoreWrapper;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFh1mSDK(jSONObject);
            }
            this.AFInAppEventType = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (AFh1nSDK)object;
        if (this.AFKeystoreWrapper != ((AFh1nSDK)object).AFKeystoreWrapper) {
            return false;
        }
        if (!this.values.equals(((AFh1nSDK)object).values)) {
            return false;
        }
        return this.AFInAppEventParameterName.equals(((AFh1nSDK)object).AFInAppEventParameterName);
    }

    public final int hashCode() {
        int n = this.AFKeystoreWrapper ? 1 : 0;
        n = n * 31 + this.values.hashCode();
        n = n * 31 + this.AFInAppEventParameterName.hashCode();
        if (this.AFInAppEventType != null) {
            n = n * 31 + ((Object)this.AFInAppEventType).hashCode();
        }
        return n;
    }
}

