/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1rSDK;
import com.appsflyer.internal.AFd1pSDK;
import com.appsflyer.internal.AFg1jSDK;
import com.appsflyer.internal.AFi1pSDK;
import com.appsflyer.internal.AFi1zSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1xSDK
extends AFi1zSDK {
    public final Map<String, Object> AFKeystoreWrapper = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService valueOf;

    public AFi1xSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFd1pSDK aFd1pSDK) {
        super("store", "google", aFd1pSDK, runnable);
        this.valueOf = executorService;
    }

    private boolean values(@NonNull Context context) {
        if (!this.AFInAppEventParameterName()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFb1rSDK.values(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.INSTANCE.d(AFg1jSDK.AFLogger, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.INSTANCE.v(AFg1jSDK.AFLogger, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.INSTANCE.e(AFg1jSDK.AFLogger, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.INSTANCE.d(AFg1jSDK.AFLogger, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void AFInAppEventType(Context context) {
        if (!this.values(context)) {
            return;
        }
        AFi1xSDK aFi1xSDK = this;
        this.AFLogger = System.currentTimeMillis();
        aFi1xSDK.registerClient = AFi1pSDK.AFa1tSDK.valueOf;
        aFi1xSDK.addObserver(new Observer(aFi1xSDK){
            private /* synthetic */ AFi1pSDK valueOf;
            {
                this.valueOf = aFi1pSDK;
            }

            public final void update(Observable observable, Object object) {
                this.valueOf.AFInAppEventParameterName.run();
            }
        });
        try {
            aFi1xSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.INSTANCE.d(AFg1jSDK.AFLogger, "Connecting to Install Referrer Library...");
            aFi1xSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFi1xSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFi1xSDK.this.valueOf.execute(() -> AFi1xSDK.this.AFInAppEventType(this.val$referrerClient, this.val$context, n));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.INSTANCE.d(AFg1jSDK.AFLogger, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.INSTANCE.e(AFg1jSDK.AFLogger, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void AFInAppEventType(InstallReferrerClient installReferrerClient, Context context, int n) {
        this.AFKeystoreWrapper.put("code", String.valueOf(n));
        String string = "com.android.vending";
        this.values.put("api_ver", AFb1rSDK.AFKeystoreWrapper(context, string));
        this.values.put("api_ver_name", AFb1rSDK.AFInAppEventType(context, string));
        switch (n) {
            case 0: {
                this.values.put("response", "OK");
                try {
                    com.appsflyer.AFLogger.INSTANCE.d(AFg1jSDK.AFLogger, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            this.AFKeystoreWrapper.put("val", object);
                            this.values.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        this.AFKeystoreWrapper.put("clk", Long.toString(l));
                        this.values.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        this.AFKeystoreWrapper.put("install", Long.toString(l2));
                        this.values.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            this.AFKeystoreWrapper.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.INSTANCE.e(AFg1jSDK.AFLogger, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.values.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    com.appsflyer.AFLogger.INSTANCE.w(AFg1jSDK.AFLogger, "ReferrerClient: InstallReferrer is not ready");
                    this.AFKeystoreWrapper.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    com.appsflyer.AFLogger.INSTANCE.w(AFg1jSDK.AFLogger, "Failed to get install referrer: " + throwable.getMessage());
                    this.AFKeystoreWrapper.put("err", throwable.getMessage());
                    com.appsflyer.AFLogger.INSTANCE.e(AFg1jSDK.AFLogger, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1jSDK.AFLogger, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.values.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.values.put("response", "SERVICE_UNAVAILABLE");
                com.appsflyer.AFLogger.INSTANCE.w(AFg1jSDK.AFLogger, "InstallReferrer not supported");
                break;
            }
            case 3: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1jSDK.AFLogger, "InstallReferrer DEVELOPER_ERROR");
                this.values.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1jSDK.AFLogger, "InstallReferrer SERVICE_DISCONNECTED");
                this.values.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1jSDK.AFLogger, "responseCode not found.");
            }
        }
        com.appsflyer.AFLogger.INSTANCE.d(AFg1jSDK.AFLogger, "Install Referrer collected locally");
        this.AFKeystoreWrapper();
    }
}

