/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1cSDK;
import com.appsflyer.internal.AFd1eSDK;
import com.appsflyer.internal.AFd1kSDK;
import com.appsflyer.internal.AFd1nSDK;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class AFe1vSDK
extends AFd1kSDK<Map<String, Object>> {
    private static final int afInfoLog = (int)TimeUnit.SECONDS.toMillis(2L);
    private Map<String, Object> AFLogger;
    private final Context afErrorLog;
    private final Map<String, Object> afRDLog;
    private final Uri afDebugLog;
    private final List<String> getLevel;

    public AFe1vSDK(@NonNull Context context, @NonNull Map<String, Object> map, @NonNull Uri uri, @NonNull List<String> list) {
        super(AFd1eSDK.afInfoLog, new AFd1eSDK[]{AFd1eSDK.AFInAppEventParameterName}, "ResolveEsp");
        this.afErrorLog = context;
        this.afRDLog = map;
        this.afDebugLog = uri;
        this.getLevel = list;
    }

    @Override
    public final long AFInAppEventParameterName() {
        return 60000L;
    }

    @Override
    public final boolean AFInAppEventType() {
        return false;
    }

    @Override
    @NonNull
    public final AFd1nSDK values() throws Exception {
        AFe1vSDK aFe1vSDK = this;
        if (!aFe1vSDK.AFInAppEventParameterName(aFe1vSDK.afDebugLog.toString())) {
            AFa1cSDK.AFInAppEventType().values(this.afErrorLog, this.afRDLog, this.afDebugLog);
            return AFd1nSDK.values;
        }
        long l = System.currentTimeMillis();
        String string = this.afDebugLog.toString();
        Integer n = null;
        Map<String, Object> map = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            map = AFe1vSDK.values(Uri.parse((String)string));
            string = (String)map.get("res");
            n = (Integer)map.get("status");
            map = (String)map.get("error");
            if (string == null || !this.AFInAppEventParameterName(string)) break;
            if (i >= 4) continue;
            ((AbstractCollection)arrayList).add(string);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("res", string != null ? string : "");
        hashMap.put("status", n != null ? n : -1);
        if (map != null) {
            hashMap.put("error", map);
        }
        if (!((AbstractCollection)arrayList).isEmpty()) {
            hashMap.put("redirects", arrayList);
        }
        hashMap.put("latency", System.currentTimeMillis() - l);
        map = this.afRDLog;
        synchronized (map) {
            this.afRDLog.put("af_deeplink_r", hashMap);
            this.afRDLog.put("af_deeplink", this.afDebugLog.toString());
        }
        AFa1cSDK.AFInAppEventType().values(this.afErrorLog, this.afRDLog, string != null ? Uri.parse((String)string) : this.afDebugLog);
        this.AFLogger = hashMap;
        return AFd1nSDK.values;
    }

    private static Map<String, Object> values(Uri object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            com.appsflyer.AFLogger.afDebugLog("ESP deeplink resolving is started: " + object.toString());
            object = (HttpURLConnection)new URL(object.toString()).openConnection();
            ((HttpURLConnection)object).setInstanceFollowRedirects(false);
            ((URLConnection)object).setReadTimeout(afInfoLog);
            ((URLConnection)object).setConnectTimeout(afInfoLog);
            ((URLConnection)object).setRequestProperty("User-agent", "Dalvik/2.1.0 (Linux; U; Android 6.0.1; Nexus 5 Build/M4B30Z)");
            ((URLConnection)object).setRequestProperty("af-esp", "6.12.4");
            int n = ((HttpURLConnection)object).getResponseCode();
            ((AbstractMap)hashMap).put("status", n);
            if (300 <= n && n <= 305) {
                ((AbstractMap)hashMap).put("res", ((URLConnection)object).getHeaderField("Location"));
            }
            ((HttpURLConnection)object).disconnect();
            com.appsflyer.AFLogger.afDebugLog("ESP deeplink resolving is finished");
        }
        catch (Throwable throwable) {
            ((AbstractMap)hashMap).put("error", throwable.getLocalizedMessage());
            com.appsflyer.AFLogger.afErrorLog(throwable.getMessage(), throwable);
        }
        return hashMap;
    }

    private boolean AFInAppEventParameterName(String string) {
        if (string.contains("af_tranid=")) {
            return false;
        }
        com.appsflyer.AFLogger.afRDLog("Validate if link " + string + " belongs to ESP domains: " + this.getLevel);
        try {
            return this.getLevel.contains(new URL(string).getHost());
        }
        catch (MalformedURLException malformedURLException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("MalformedURLException ESP link", malformedURLException);
            return false;
        }
    }
}

