/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1fSDK;
import com.appsflyer.internal.AFc1ySDK;
import com.appsflyer.internal.AFf1jSDK;
import java.util.Observable;
import java.util.Observer;

@RequiresApi(api=19)
public final class AFf1hSDK
extends AFf1jSDK {
    final ProviderInfo AFKeystoreWrapper;
    private final AFc1ySDK AFInAppEventType;

    public AFf1hSDK(ProviderInfo providerInfo, Runnable runnable, AFc1ySDK aFc1ySDK) {
        super("af_referrer", providerInfo.authority, runnable);
        this.AFInAppEventType = aFc1ySDK;
        this.AFKeystoreWrapper = providerInfo;
    }

    @Override
    public final void valueOf(Context object) {
        object = new Runnable(this, (Context)object){
            private /* synthetic */ Context AFInAppEventParameterName;
            private /* synthetic */ AFf1hSDK values;
            {
                this.values = aFf1hSDK;
                this.AFInAppEventParameterName = context;
            }

            @Override
            public final void run() {
                AFf1hSDK aFf1hSDK = this.values;
                this.values.AFLogger = System.currentTimeMillis();
                aFf1hSDK.afDebugLog = AFf1jSDK.AFa1vSDK.AFInAppEventType;
                aFf1hSDK.addObserver(new Observer(aFf1hSDK){
                    private /* synthetic */ AFf1jSDK AFInAppEventParameterName;
                    {
                        this.AFInAppEventParameterName = aFf1jSDK;
                    }

                    public final void update(Observable observable, Object object) {
                        this.AFInAppEventParameterName.AFInAppEventParameterName.run();
                    }
                });
                aFf1hSDK = Uri.parse((String)("content://" + this.values.AFKeystoreWrapper.authority + "/transaction_id"));
                ContentProviderClient contentProviderClient = AFf1hSDK.AFKeystoreWrapper(this.AFInAppEventParameterName, (Uri)aFf1hSDK);
                Cursor cursor = null;
                if (contentProviderClient != null) {
                    try {
                        cursor = contentProviderClient.query((Uri)aFf1hSDK, null, "app_id=" + this.AFInAppEventParameterName.getPackageName(), null, null);
                    }
                    catch (DeadObjectException deadObjectException) {
                        com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient", deadObjectException, false);
                    }
                    catch (RemoteException remoteException) {
                        com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to query unstable content providerClient", remoteException, false);
                    }
                    catch (Throwable throwable) {
                        com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Error to get data from providerClient ", throwable, false);
                    }
                    finally {
                        if (Build.VERSION.SDK_INT >= 24) {
                            contentProviderClient.close();
                        } else {
                            contentProviderClient.release();
                        }
                    }
                }
                if (cursor != null) {
                    int n = cursor.getColumnIndex("transaction_id");
                    if (n == -1) {
                        com.appsflyer.AFLogger.afWarnLog("[Preinstall]: Wrong column name");
                        this.values.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                    } else {
                        this.values.valueOf.put("response", "OK");
                        if (cursor.moveToFirst()) {
                            String string = cursor.getString(n);
                            cursor.close();
                            if (string != null && !string.isEmpty()) {
                                this.values.valueOf.put("referrer", string);
                            }
                        }
                    }
                    cursor.close();
                } else {
                    com.appsflyer.AFLogger.afWarnLog("[Preinstall]: ContentProvider query failed, got null Cursor");
                    this.values.valueOf.put("response", "SERVICE_UNAVAILABLE");
                }
                this.values.valueOf.put("api_ver", AFa1fSDK.AFInAppEventParameterName(this.AFInAppEventParameterName, this.values.AFKeystoreWrapper.packageName));
                this.values.valueOf.put("api_ver_name", AFa1fSDK.AFKeystoreWrapper(this.AFInAppEventParameterName, this.values.AFKeystoreWrapper.packageName));
                this.values.AFKeystoreWrapper();
            }
        };
        this.AFInAppEventType.AFInAppEventType().execute((Runnable)object);
    }

    @VisibleForTesting
    @Nullable
    public static ContentProviderClient AFKeystoreWrapper(Context context, Uri uri) {
        ContentProviderClient contentProviderClient = null;
        try {
            contentProviderClient = context.getContentResolver().acquireUnstableContentProviderClient(uri);
        }
        catch (SecurityException securityException) {
            com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient due to SecurityException", securityException, false);
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient due to unexpected throwable", throwable, false);
        }
        return contentProviderClient;
    }
}

