/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFe1wSDK;
import com.appsflyer.internal.AFf1vSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFe1mSDK {
    private final boolean values;
    @NonNull
    public final String AFInAppEventType;
    @NonNull
    public final String valueOf;
    @NonNull
    public final AFf1vSDK AFKeystoreWrapper;
    @Nullable
    public final AFe1wSDK AFInAppEventParameterName;

    public AFe1mSDK() {
    }

    public static boolean AFKeystoreWrapper(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            return context.getPackageManager().isInstantApp();
        }
        try {
            context.getClassLoader().loadClass("com.google.android.instantapps.supervisor.InstantAppsRuntime");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstantAppsRuntime not found", classNotFoundException, true);
            return false;
        }
    }

    public AFe1mSDK(String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.AFInAppEventType = jSONObject.getString("ver");
            this.values = jSONObject.optBoolean("test_mode");
            this.valueOf = object;
            this.AFKeystoreWrapper = this.AFInAppEventType.startsWith("default") ? AFf1vSDK.AFInAppEventType : AFf1vSDK.AFKeystoreWrapper;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFe1wSDK(jSONObject);
            }
            this.AFInAppEventParameterName = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (AFe1mSDK)object;
        if (this.values != ((AFe1mSDK)object).values) {
            return false;
        }
        if (!this.AFInAppEventType.equals(((AFe1mSDK)object).AFInAppEventType)) {
            return false;
        }
        return this.valueOf.equals(((AFe1mSDK)object).valueOf);
    }

    public final int hashCode() {
        int n = this.values ? 1 : 0;
        n = n * 31 + this.AFInAppEventType.hashCode();
        n = n * 31 + this.valueOf.hashCode();
        if (this.AFInAppEventParameterName != null) {
            n = n * 31 + ((Object)this.AFInAppEventParameterName).hashCode();
        }
        return n;
    }
}

