/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1cSDK;
import com.appsflyer.internal.AFf1jSDK;
import com.appsflyer.internal.AFf1oSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFf1pSDK
extends AFf1oSDK {
    public final Map<String, Object> values = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService valueOf;

    public AFf1pSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService) {
        super("store", "google", runnable);
        this.valueOf = executorService;
    }

    private static boolean AFInAppEventParameterName(@NonNull Context context) {
        if (!AFf1pSDK.AFKeystoreWrapper()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFa1cSDK.AFInAppEventType(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void AFKeystoreWrapper(Context context) {
        if (!AFf1pSDK.AFInAppEventParameterName(context)) {
            return;
        }
        AFf1pSDK aFf1pSDK = this;
        this.AFLogger = System.currentTimeMillis();
        aFf1pSDK.afRDLog = AFf1jSDK.AFa1vSDK.valueOf;
        aFf1pSDK.addObserver(new Observer(aFf1pSDK){
            private /* synthetic */ AFf1jSDK AFInAppEventType;
            {
                this.AFInAppEventType = aFf1jSDK;
            }

            public final void update(Observable observable, Object object) {
                this.AFInAppEventType.AFInAppEventType.run();
            }
        });
        try {
            aFf1pSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFf1pSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFf1pSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFf1pSDK.this.valueOf.execute(() -> AFf1pSDK.AFKeystoreWrapper(AFf1pSDK.this, this.val$referrerClient, this.val$context, n));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }

    static /* synthetic */ void AFKeystoreWrapper(AFf1pSDK aFf1pSDK, InstallReferrerClient installReferrerClient, Context context, int n) {
        aFf1pSDK.values.put("code", String.valueOf(n));
        String string = "com.android.vending";
        aFf1pSDK.AFKeystoreWrapper.put("api_ver", AFa1cSDK.valueOf(context, string));
        aFf1pSDK.AFKeystoreWrapper.put("api_ver_name", AFa1cSDK.AFInAppEventParameterName(context, string));
        switch (n) {
            case 0: {
                aFf1pSDK.AFKeystoreWrapper.put("response", "OK");
                try {
                    com.appsflyer.AFLogger.afDebugLog("InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            aFf1pSDK.values.put("val", object);
                            aFf1pSDK.AFKeystoreWrapper.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        aFf1pSDK.values.put("clk", Long.toString(l));
                        aFf1pSDK.AFKeystoreWrapper.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        aFf1pSDK.values.put("install", Long.toString(l2));
                        aFf1pSDK.AFKeystoreWrapper.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            aFf1pSDK.values.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            aFf1pSDK.AFKeystoreWrapper.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    com.appsflyer.AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                    aFf1pSDK.values.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    com.appsflyer.AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                    aFf1pSDK.values.put("err", throwable.getMessage());
                    com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                }
                break;
            }
            case 2: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                aFf1pSDK.AFKeystoreWrapper.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                aFf1pSDK.AFKeystoreWrapper.put("response", "SERVICE_UNAVAILABLE");
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer not supported");
                break;
            }
            case 3: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                aFf1pSDK.AFKeystoreWrapper.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                aFf1pSDK.AFKeystoreWrapper.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                com.appsflyer.AFLogger.afWarnLog("responseCode not found.");
            }
        }
        com.appsflyer.AFLogger.afDebugLog("Install Referrer collected locally");
        aFf1pSDK.AFInAppEventType();
    }
}

