/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1dSDK;
import com.appsflyer.internal.AFd1uSDK;
import com.appsflyer.internal.AFd1vSDK;
import com.appsflyer.internal.AFd1ySDK;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class AFd1lSDK
extends AFd1uSDK<Map<String, Object>> {
    private static final int afRDLog = (int)TimeUnit.SECONDS.toMillis(2L);
    private Map<String, Object> afErrorLog;
    private final Context afDebugLog;
    private final Map<String, Object> AFLogger;
    private final Uri afInfoLog;
    private final List<String> AFVersionDeclaration;

    public AFd1lSDK(@NonNull Context context, @NonNull Map<String, Object> map, @NonNull Uri uri, @NonNull List<String> list) {
        super(AFd1vSDK.afDebugLog, new AFd1vSDK[]{AFd1vSDK.AFKeystoreWrapper}, "ResolveEsp");
        this.afDebugLog = context;
        this.AFLogger = map;
        this.afInfoLog = uri;
        this.AFVersionDeclaration = list;
    }

    @Override
    public final long AFKeystoreWrapper() {
        return 60000L;
    }

    @Override
    public final boolean AFInAppEventType() {
        return false;
    }

    @Override
    @NonNull
    public final AFd1ySDK values() throws Exception {
        AFd1lSDK aFd1lSDK = this;
        if (!aFd1lSDK.AFKeystoreWrapper(aFd1lSDK.afInfoLog.toString())) {
            AFa1dSDK.valueOf().values(this.afDebugLog, this.AFLogger, this.afInfoLog);
            return AFd1ySDK.AFInAppEventType;
        }
        long l = System.currentTimeMillis();
        String string = this.afInfoLog.toString();
        Integer n = null;
        Map<String, Object> map = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            map = AFd1lSDK.AFInAppEventParameterName(Uri.parse((String)string));
            string = (String)map.get("res");
            n = (Integer)map.get("status");
            map = (String)map.get("error");
            if (string == null || !this.AFKeystoreWrapper(string)) break;
            if (i >= 4) continue;
            ((AbstractCollection)arrayList).add(string);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("res", string != null ? string : "");
        hashMap.put("status", n != null ? n : -1);
        if (map != null) {
            hashMap.put("error", map);
        }
        if (!((AbstractCollection)arrayList).isEmpty()) {
            hashMap.put("redirects", arrayList);
        }
        hashMap.put("latency", System.currentTimeMillis() - l);
        map = this.AFLogger;
        synchronized (map) {
            this.AFLogger.put("af_deeplink_r", hashMap);
            this.AFLogger.put("af_deeplink", this.afInfoLog.toString());
        }
        AFa1dSDK.valueOf().values(this.afDebugLog, this.AFLogger, string != null ? Uri.parse((String)string) : this.afInfoLog);
        this.afErrorLog = hashMap;
        return AFd1ySDK.AFInAppEventType;
    }

    private static Map<String, Object> AFInAppEventParameterName(Uri object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            com.appsflyer.AFLogger.afDebugLog("ESP deeplink resolving is started: " + object.toString());
            object = (HttpURLConnection)new URL(object.toString()).openConnection();
            ((HttpURLConnection)object).setInstanceFollowRedirects(false);
            ((URLConnection)object).setReadTimeout(afRDLog);
            ((URLConnection)object).setConnectTimeout(afRDLog);
            ((URLConnection)object).setRequestProperty("User-agent", "Dalvik/2.1.0 (Linux; U; Android 6.0.1; Nexus 5 Build/M4B30Z)");
            ((URLConnection)object).setRequestProperty("af-esp", "6.12.1");
            int n = ((HttpURLConnection)object).getResponseCode();
            ((AbstractMap)hashMap).put("status", n);
            if (300 <= n && n <= 305) {
                ((AbstractMap)hashMap).put("res", ((URLConnection)object).getHeaderField("Location"));
            }
            ((HttpURLConnection)object).disconnect();
            com.appsflyer.AFLogger.afDebugLog("ESP deeplink resolving is finished");
        }
        catch (Throwable throwable) {
            ((AbstractMap)hashMap).put("error", throwable.getLocalizedMessage());
            com.appsflyer.AFLogger.afErrorLog(throwable.getMessage(), throwable);
        }
        return hashMap;
    }

    private boolean AFKeystoreWrapper(String string) {
        if (string.contains("af_tranid=")) {
            return false;
        }
        com.appsflyer.AFLogger.afRDLog("Validate if link " + string + " belongs to ESP domains: " + this.AFVersionDeclaration);
        try {
            return this.AFVersionDeclaration.contains(new URL(string).getHost());
        }
        catch (MalformedURLException malformedURLException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("MalformedURLException ESP link", malformedURLException);
            return false;
        }
    }
}

