/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1fSDK;
import com.appsflyer.internal.AFg1tSDK;
import com.appsflyer.internal.AFg1ySDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFg1xSDK
extends AFg1ySDK {
    public final Map<String, Object> values = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFKeystoreWrapper;

    public AFg1xSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService) {
        super("store", "google", runnable);
        this.AFKeystoreWrapper = executorService;
    }

    private static boolean AFInAppEventParameterName(@NonNull Context context) {
        if (!AFg1xSDK.AFInAppEventType()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFa1fSDK.values(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void valueOf(Context context) {
        if (!AFg1xSDK.AFInAppEventParameterName(context)) {
            return;
        }
        AFg1xSDK aFg1xSDK = this;
        this.afDebugLog = System.currentTimeMillis();
        aFg1xSDK.afInfoLog = AFg1tSDK.AFa1ySDK.AFInAppEventType;
        aFg1xSDK.addObserver(new Observer(aFg1xSDK){
            private /* synthetic */ AFg1tSDK valueOf;
            {
                this.valueOf = aFg1tSDK;
            }

            public final void update(Observable observable, Object object) {
                this.valueOf.AFInAppEventType.run();
            }
        });
        try {
            aFg1xSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFg1xSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFg1xSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n2) {
                    AFg1xSDK.this.AFKeystoreWrapper.execute(() -> AFg1xSDK.valueOf(AFg1xSDK.this, this.val$referrerClient, this.val$context, n2));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }

    static /* synthetic */ void valueOf(AFg1xSDK aFg1xSDK, InstallReferrerClient installReferrerClient, Context context, int n2) {
        aFg1xSDK.values.put("code", String.valueOf(n2));
        String string = "com.android.vending";
        aFg1xSDK.valueOf.put("api_ver", AFa1fSDK.valueOf(context, string));
        aFg1xSDK.valueOf.put("api_ver_name", AFa1fSDK.AFInAppEventParameterName(context, string));
        switch (n2) {
            case 0: {
                aFg1xSDK.valueOf.put("response", "OK");
                try {
                    AFLogger.afDebugLog("InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            aFg1xSDK.values.put("val", object);
                            aFg1xSDK.valueOf.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        aFg1xSDK.values.put("clk", Long.toString(l));
                        aFg1xSDK.valueOf.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        aFg1xSDK.values.put("install", Long.toString(l2));
                        aFg1xSDK.valueOf.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            aFg1xSDK.values.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            aFg1xSDK.valueOf.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                    aFg1xSDK.values.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                    aFg1xSDK.values.put("err", throwable.getMessage());
                    AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                }
                break;
            }
            case 2: {
                AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                aFg1xSDK.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                aFg1xSDK.valueOf.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.afWarnLog("InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                aFg1xSDK.valueOf.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                aFg1xSDK.valueOf.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.afWarnLog("responseCode not found.");
            }
        }
        AFLogger.afDebugLog("Install Referrer collected locally");
        aFg1xSDK.AFInAppEventParameterName();
    }
}

